#!/bin/bash

# This script is located at /Users/rlps281/workspace/noisy-al/single_setting_experiments.sh

# Add your commands below

echo "Running single setting experiments..."
# Example command
# ./run_experiment.sh --setting single

# Add more commands as needed
# python run_single.py \
#     --estimation_approach cheat \
#     --oracle_type  1 \
#     --oracle_noise_level 0.5 \
#     --dataset SyntheticRegular \
#     --init corner \
#     --strategy random 

# Define variables
DATASETS=("SyntheticRegular" "SyntheticNonRegular_2_4" "SyntheticFreqPower_4_4")
INIT_TYPES=("corner" "random")
# STRATEGIES=("bias_reduction" "max_term_selection" "diff_least_confidence" "diff_emse" "diff_bias_reduction" "diff_max_term_selection" "random" "least_confidence" "emse")
STRATEGIES=("diff_emse" "diff_bias_reduction" "random" "least_confidence")

ESTIMATION_APPROACHES=("quadratic")
ORACLE_TYPES=(1 2 3)

for dataset in "${DATASETS[@]}"; do
    for init_type in "${INIT_TYPES[@]}"; do
        for strategy in "${STRATEGIES[@]}"; do
            for estimation_approach in "${ESTIMATION_APPROACHES[@]}"; do
                for oracle_type in "${ORACLE_TYPES[@]}"; do
                    python run_single.py \
                        --estimation_approach $estimation_approach \
                        --oracle_type $oracle_type \
                        --oracle_noise_level 0.5 \
                        --dataset $dataset \
                        --init $init_type \
                        --strategy $strategy 
                done
            done
        done
    done
done

