import pytest
import numpy as np
from aiau.oracles.oracle import Oracle
from aiau.data.data_manager import DataManager


class DummyDataManager(DataManager):
    """Minimal mock of DataManager for unit testing the Oracle."""
    def __init__(self):
        self.targets_dict = {
            0: 1.0,
            1: 2.0,
            2: 3.0,
            3: 4.0
        }


def test_query_target_value_returns_correct_targets():
    oracle = Oracle()
    dm = DummyDataManager()

    result = oracle.query_target_value(dm, [0, 2, 3])

    assert isinstance(result, list)
    assert result == [1.0, 3.0, 4.0]


def test_query_target_value_empty_indices():
    oracle = Oracle()
    dm = DummyDataManager()

    result = oracle.query_target_value(dm, [])

    assert isinstance(result, list)
    assert result == []


def test_query_target_value_invalid_index_raises_key_error():
    oracle = Oracle()
    dm = DummyDataManager()

    with pytest.raises(KeyError):
        oracle.query_target_value(dm, [99])