import sys
import yaml
from experiment import *
import random
import numpy as np
import torch
import matplotlib
import os



def main():
    matplotlib.use('Agg')
    with open(sys.argv[1], "r") as ymlfile:
        cfg = yaml.load(ymlfile, Loader= yaml.FullLoader )
        experiment_name = cfg['name']
        dataset_name = cfg['dataset']
        modelname = cfg['modelname']
        train_mode = cfg['train_mode']
        max_epochs = cfg['max_epochs']
        train_type = cfg['train_type']
        pruning_algorithms = cfg['pruning_algorithms']
        pruning_ratios = cfg['pruning_ratios']
        num_iters = cfg['repetitions']
        width_factor = cfg['width_factor']
        data_dir = cfg['data_dir']
        start_seed = cfg['start_seed']
        #pretrain_epochs = cfg['pretrain_epochs']
        #max_finetuning_epochs = cfg['max_fine_tuning_epochs']
        #samples_N = cfg['samples_N']

    cwd = os.getcwd()
    my_experiment = Experiment(experiment_name,cwd,cfg)
    my_experiment.define_pruning_algorithm_names(pruning_algorithms)
    my_experiment.plot_average_results(pruning_ratios,modelname,train_type,num_iters)

if __name__ == "__main__":
    main()
