# RL-Augment

Install
```commandline
cd DataAugmentation_code_final
pip install -e .
cd augment
pip install -e Gymnasium-Robotics
pip install -e panda-gym
pip install -e my-gym

pip install torch==1.12.0+cu116 --extra-index-url https://download.pytorch.org/whl/cu116
conda install -c conda-forge stable-baselines3
conda install pyyaml
conda install six
```

## Code Description

We build out codebase on top of Stable Baselines3 and SB3 RL Zoo.

### Environment Packages
* `my-gym`: This package contains the Goal2D environment as well as MuJoCo environments that needed modifications to ensure intuitive symmetries were not broken (see appendix for details).
* `panda-gym`: This package contains panda-gym environments. We modified environments to make it work nicely with our augmentation framework (e.g. observations are returned as numpy arrays rather than dictionaries).
* `Gymnasium-Robotics`: This is a Gymnasium-Robotics which we modified to be compatible with Stable Baselines3.

### RL Training
The `rl` directory contains the core RL training code.

* `rl/algs`: This directory contains modified implementations of DDPG and TD3 that work within our augmentation framework.
* `rl/augmentation_functions`: This directory contains all augmentations functions used in the paper's main body and appendix.
* `rl/hyperparams`: Default DDPG and TD3 hyperparameters for all tasks.

You can train agents using `python train.py`.
Augmented samples are generated inside the `collect_rollouts()` function in `rl/off_policy_algorithm.py`

We provide the commands used to generate results from the main paper in the `gen_commands/commands` directory.
