import copy
import os

import gym
from gym.envs.registration import register

ENVS_DIR = os.path.join(os.path.dirname(__file__), 'envs')


# unregister gym's env so I can use the same name
# envs_to_unregister = ['Ant-v3', 'HalfCheetah-v3', 'Humanoid-v3', 'Walker2d-v3']
# envs_to_unregister = [
#     'CartPole-v1', 'InvertedPendulum-v2', 'InvertedDoublePendulum-v2',
#     'Ant-v3', 'HalfCheetah-v3', 'Humanoid-v3', 'Walker2d-v3', 'Hopper-v3', 'Swimmer-v3', 'HumanoidStandup-v2']
# for env_id in envs_to_unregister:
#     if env_id in gym.envs.registry.env_specs:
#         del gym.envs.registry.env_specs[env_id]
# env_ids = list(gym.envs.registry.env_specs.keys())
# for env_id in env_ids:
#         del gym.envs.registry.env_specs[env_id]

###########################################################################
### Classic control

# register(
#     id="CartPole-v1",
#     entry_point="my_gym.envs.cartpole:CartPoleEnv",
#     max_episode_steps=500,
# )

###########################################################################
### Mujoco

register(
    id="Walker2d-v4",
    max_episode_steps=1000,
    entry_point="my_gym.envs.mujoco:Walker2dEnv",
)
register(
    id="Humanoid-v4",
    entry_point="my_gym.envs.mujoco.humanoid_v4:HumanoidEnv",
    max_episode_steps=1000,
)
register(
    id="HumanoidStandup-v4",
    entry_point="my_gym.envs.mujoco.humanoidstandup_v4:HumanoidStandupEnv",
    max_episode_steps=1000,
)

# ----------------------------------------

# 2D
#
register(
    id="Reacher-v4",
    entry_point="my_gym.envs.mujoco:ReacherEnv",
    max_episode_steps=50,
    reward_threshold=-3.75,
)
#
# register(
#     id="Pusher-v2",
#     entry_point="my_gym.envs.mujoco:PusherEnv",
#     max_episode_steps=100,
#     reward_threshold=0.0,
# )
#
register(
    id="InvertedPendulum-v4",
    entry_point="my_gym.envs.mujoco.inverted_pendulum_v4:InvertedPendulumEnv",
    max_episode_steps=1000,
)
#
register(
    id="InvertedDoublePendulum-v4",
    entry_point="my_gym.envs.mujoco.inverted_double_pendulum_v4:InvertedDoublePendulumEnv",
    max_episode_steps=1000,
    reward_threshold=9100.0,
)
#
# register(
#     id="InvertedPendulumWide-v2",
#     entry_point="my_gym.envs.mujoco.inverted_pendulum:InvertedPendulumEnv",
#     max_episode_steps=1000,
#     kwargs={
#         'init_pos': [-0.9, 0.9]
#     }
# )
#
# register(
#     id="InvertedDoublePendulumWide-v2",
#     entry_point="my_gym.envs.mujoco.inverted_double_pendulum:InvertedDoublePendulumEnv",
#     max_episode_steps=1000,
#     reward_threshold=9100.0,
#     kwargs={
#         'init_pos': [-0.9, 0.9]
#     }
# )
#
#
# register(
#     id="HalfCheetah-v3",
#     entry_point="my_gym.envs.mujoco.half_cheetah_v3:HalfCheetahEnv",
#     max_episode_steps=1000,
#     reward_threshold=4800.0,
# )
#
# register(
#     id="Hopper-v3",
#     entry_point="my_gym.envs.mujoco.hopper_v3:HopperEnv",
#     max_episode_steps=1000,
#     reward_threshold=3800.0,
# )
#
# register(
#     id="Swimmer-v3",
#     entry_point="my_gym.envs.mujoco.swimmer_v3:SwimmerEnv",
#     max_episode_steps=1000,
#     reward_threshold=360.0,
# )
#
#
# register(
#     id="HumanoidStandup-v2",
#     entry_point="my_gym.envs.mujoco:HumanoidStandupEnv",
#     max_episode_steps=1000,
# )
# #
# # ###########################################################################
#
# register(
#     id=f'Swimmer10-v3',
#     entry_point='my_gym.envs.mujoco:SwimmerKEnv',
#     kwargs={'num_links': 10},
#     max_episode_steps=1000,
# )
#
# register(
#     id=f'Swimmer20-v3',
#     entry_point='my_gym.envs.mujoco:SwimmerKEnv',
#     kwargs={'num_links': 20},
#     max_episode_steps=1000,
# )
#
# for k in [2,4,8,12,16,20]:
    # register(
    #     id=f'ReacherTracker{k}-v3',
    #     entry_point='my_gym.envs.mujoco:ReacherTrackerEnv',
    #     kwargs={'num_links': k},
    #     max_episode_steps=200,
    # )

    # register(
    #     id=f'Reacher{k}-v4',
    #     entry_point='my_gym.envs.mujoco:ReacherEnv',
    #     kwargs={'num_links': k},
    #     max_episode_steps=100,
    # )
#
#     register(
#         id=f'Reacher{k}Sparse-v3',
#         entry_point='my_gym.envs.mujoco:ReacherEnv',
#         kwargs={'num_links': k, 'sparse': True},
#         max_episode_steps=100,
#     )
#
#     register(
#         id=f'Reacher{k}Rand-v3',
#         entry_point='my_gym.envs.mujoco:ReacherEnv',
#         kwargs={
#             'num_links': k,
#             'rand_central_angle': True
#         },
#         max_episode_steps=100,
#     )

############################################################################
### Fetch


# Fetch

register(
    id=f"FetchReach-v2",
    entry_point="my_gym.envs.fetch:MujocoFetchReachEnv",
    max_episode_steps=50,
)

register(
    id=f"FetchPush-v2",
    entry_point="my_gym.envs.fetch:MujocoFetchPushEnv",
    max_episode_steps=50,
)

register(
    id=f"FetchSlide-v2",
    entry_point="my_gym.envs.fetch:MujocoFetchSlideEnv",
    max_episode_steps=50,
)

register(
    id=f"FetchPickAndPlace-v2",
    entry_point="my_gym.envs.fetch:MujocoFetchPickAndPlaceEnv",
    max_episode_steps=50,
)

############################################################################
### Toy

register(
    id="Goal2D-v0",
    entry_point="my_gym.envs:Goal2DEnv",
    max_episode_steps=100,
)
register(
    id="Goal2DKey-v0",
    entry_point="my_gym.envs:Goal2DKeyEnv",
    max_episode_steps=100,
)
register(
    id="Goal2DQuadrant-v0",
    entry_point="my_gym.envs:Goal2DQuadrantEnv",
    max_episode_steps=100,
)