# from augment.rl.augmentation_functions.fetch import FETCH_PUSH_AUG_FUNCTIONS, FETCH_SLIDE_AUG_FUNCTIONS, FETCH_AUG_FUNCTIONS
from augment.rl.augmentation_functions.goal2d import GOAL2D_AUG_FUNCTIONS
from augment.rl.augmentation_functions.humanoid import HUMANOID_AUG_FUNCTIONS
from augment.rl.augmentation_functions.panda.common import PANDA_AUG_FUNCTIONS
from augment.rl.augmentation_functions.panda.flip import PANDA_FLIP_AUG_FUNCTIONS
from augment.rl.augmentation_functions.panda.pickandplace import PANDA_PICKANDPLACE_AUG_FUNCTIONS
from augment.rl.augmentation_functions.panda.push import PANDA_PUSH_AUG_FUNCTIONS
from augment.rl.augmentation_functions.panda.slide import PANDA_SLIDE_AUG_FUNCTIONS
from augment.rl.augmentation_functions.swimmer import SWIMMER_AUG_FUNCTIONS


from augment.rl.augmentation_functions.walker2d import WALKER2D_AUG_FUNCTIONS
from augment.rl.augmentation_functions.ant import ANT_AUG_FUNCTIONS


AUGMENTATION_FUNCTIONS = {
    # Toy
    'Goal2D': GOAL2D_AUG_FUNCTIONS,
    'Goal2DQuadrant': GOAL2D_AUG_FUNCTIONS,

    # locomotion
    'Swimmer': SWIMMER_AUG_FUNCTIONS,
    'Walker2d': WALKER2D_AUG_FUNCTIONS,
    'Ant': ANT_AUG_FUNCTIONS,
    'Humanoid': HUMANOID_AUG_FUNCTIONS,

    # robotics
    'PandaPush': PANDA_PUSH_AUG_FUNCTIONS,
    'PandaSlide': PANDA_SLIDE_AUG_FUNCTIONS,
    'PandaPickAndPlace': PANDA_PICKANDPLACE_AUG_FUNCTIONS,
    'PandaFlip': PANDA_FLIP_AUG_FUNCTIONS,

}
