import numpy as np

from utils import gen_args, write_to_file

DISK = 7
#--run-id-offset 20

AUG_N_TO_MEM = {
    2: 4,
    3: 4,
    4: 4,
    6: 4.5,
    8: 5,
    12: 5.5,
    16: 6,
    18: 6.5,
    24: 10,
    32: 10
}

def arg_generator(env_id, aug_function, aug_ratio, lambda_, aug_n, mem, rr=2):
    disk = 10

    alpha = lambda_

    if np.isclose(lambda_, 0):
        n_extra_collect = 0
        extra_collect_freq = 0
    if np.isclose(lambda_, 1/3):
        n_extra_collect = 1
        extra_collect_freq = 3
    if np.isclose(lambda_, 2/3):
        n_extra_collect = 2
        extra_collect_freq = 3
    if np.isclose(lambda_, 1):
        n_extra_collect = 0
        extra_collect_freq = 0

    df = 2 - lambda_

    args = f" --env {env_id}" \
           f" -exp {aug_function}/ratio_{aug_ratio}/lambda_{lambda_:.2f}" \
           f" --aug-function {aug_function} --aug-ratio {lambda_} --aug-n {alpha}" \
           f" --data-factor {df}" \
           f" --hyperparams extra_collect_info:{n_extra_collect},{extra_collect_freq}"
    return mem, disk, args

def write_args():

    env_ids = ['PandaPush-v3', 'PandaSlide-v3', 'PandaFlip-v3', 'PandaPickAndPlace-v3']

    for aug_function in ['translate_goal_proximal_0']:
        f = open(f"commands/coverage.txt", "w")
        for env_id in env_ids:
            for lambda_ in [0,1/3, 2/3, 1]:
                args = gen_args(
                    device='cpu',
                    length="short",
                    arg_generator=arg_generator,
                    aug_function=aug_function,
                    env_id=env_id,
                    aug_ratio=1,
                    aug_n=1,
                    mem=1.6,
                    lambda_=lambda_)
                write_to_file(f, args)


if __name__ == "__main__":

    write_args()


