from utils import gen_args, write_to_file

DISK = 7
DEFAULTS = f'--eval-episodes 50 --algo ddpg -n 1000000'  #

N_TO_MEM = {
    1: 1.6,
    2: 1.6,
    3: 2,
    4: 2,
    8: 5,
    16: 6,
    32: 10
}

def arg_generator(env_id, df):
    disk = 10

    args = f" --env {env_id} -n 1000000" \
           f" -exp no_aug/df_{df}" \
           f" --data-factor {df}" \

    mem = N_TO_MEM[df]

    return mem, disk, args

def write_args():


    env_ids = ['Goal2D-v0', 'PandaPush-v3', 'PandaSlide-v3', 'PandaFlip-v3', 'PandaPickAndPlace-v3' ]

    f = open(f"commands/no_augmentation.txt", "w")
    for env_id in env_ids:
        if env_id == 'Goal2D-v0':
            dfs = [1,2,4,8]
        else:
            dfs = [1,2,4]
        for df in dfs:
            args = gen_args(
                device='cuda',
                length='short',
                arg_generator=arg_generator,
                env_id=env_id,
                df=df,
            )
            write_to_file(f, args)


if __name__ == "__main__":

    write_args()


