from utils import gen_args, write_to_file

DISK = 7
DEFAULTS = f'--eval-episodes 50 --algo ddpg -n 1000000'  #

CPU_MEM = {
    1: 2,
    2: 2,
    4: 2,
    8: 3,
    16: 4.5,
}

GPU_MEM = {
    2: 4,
    3: 4,
    4: 4,
    6: 4.5,
    8: 5,
    12: 5.5,
    16: 6,
    18: 6.5,
    24: 10,
    32: 10
}

def arg_generator(env_id, aug_function, aug_ratio, aug_n, p):
    # mem = N_TO_MEM[aug_n]
    disk = 10

    args = f" --env {env_id} " \
           f" -exp {aug_function}/p_{p}/ratio_{aug_ratio}/n_{aug_n}" \
           f" --aug-function {aug_function} --aug-function-kwargs p:{p} --aug-ratio {aug_ratio} --aug-n {aug_n} --hyperparams train_freq:2 gradient_steps:1"
    mem = CPU_MEM[aug_n]

    return mem, disk, args

def write_args():


    env_ids = ['PandaPush-v3', 'PandaSlide-v3', 'PandaFlip-v3', 'PandaPickAndPlace-v3' ]
    # env_ids = [ 'PandaPickAndPlace-v3' ]
    # env_ids = ['PandaSlide-v3']

    f = open(f"commands/reward_density.txt", "w")
    for aug_function in ['translate_goal_proximal']:
        for env_id in env_ids:
            for p in [0, 0.05, 0.1, 0.25]:
                args = gen_args(
                    device='cpu',
                    length="medium",
                    arg_generator=arg_generator,
                    aug_function=aug_function,
                    env_id=env_id,
                    aug_ratio=1,
                    aug_n=1,
                    p=p)
                write_to_file(f, args)

if __name__ == "__main__":

    write_args()


