DEFAULTS = f'--eval-episodes 80 --algo ddpg'

def write_to_file(f, args):
    # args = args.replace(' ', '*')
    print(args)
    f.write(args + "\n")

def gen_args(device, length, arg_generator, **kwargs):
    assert (device == 'cpu') or (device == 'cuda')
    if device == 'cuda':
        device_args = f'\"{length}\",--device cuda'
    else:
        device_args = f'--device cpu'


    mem, disk, other_args = arg_generator(**kwargs)

    default_args = f"{mem},{disk},{device_args} {DEFAULTS}"
    if 'Pick' in other_args:
        default_args += ' -n 1500000'
    elif 'Push' in other_args:
        default_args += ' -n 600000'
    elif 'Goal2D' in other_args:
        default_args += ' --algo td3 -n 500000'
    else:
        default_args += ' -n 1000000'

    args = default_args + other_args
    args = "python train.py" + other_args

    return args
