#!/bin/bash


export MASTER_PORT=$(python -c "import socket; s=socket.socket(); s.bind(('', 0)); print(s.getsockname()[1]); s.close()")
echo "Master Port: $MASTER_PORT"


# #########################################################
# #################### MUSE Unlearning ####################
# #########################################################

# #########################################################
# #################### MUSE Unlearning ####################
# #########################################################

per_device_train_batch_size=4
gradient_accumulation_steps=4

models_and_temps=(
    # "Llama-2-7b-hf 0.5"
    "Llama-2-7b-hf 2.0"
)

trainers=(
    "ATTU_output"
)

trainable_params_lists=(
    "[\".*\"]"
    # "[\"model\\.layers\\.\\d+\\.mlp\\..*\"]"
    # "[\"model\\.layers\\.\\d+\\.self_attn\\..*\"]"
)

data_splits=(
    "News"
    "Books"
)

alpha=0.4
alpha_tag=${alpha//./p}

for data_split in "${data_splits[@]}"; do
    for mt in "${models_and_temps[@]}"; do
        # Split "MODEL TEMP"
        read -r model temp <<< "$mt"
        # Safe tag for filenames: 0.5 -> 0p5
        temp_tag=${temp//./p}
        for trainer in "${trainers[@]}"; do
            for regex_list in "${trainable_params_lists[@]}"; do
                # Tag which params are trainable
                if [[ "$regex_list" == '["model\.layers\.\d+\.self_attn\..*"]' ]]; then
                tp_tag="attention"
                elif [[ "$regex_list" == '["model\.layers\.\d+\.mlp\..*"]' ]]; then
                tp_tag="mlp"
                elif [[ "$regex_list" == '[".*"]' ]]; then
                tp_tag="all"
                else
                tp_tag="custom"
                fi

                # task_name=muse_${model}_${data_split}_${trainer}
                task_name=muse_${model}_${data_split}_${trainer}_T${temp_tag}_P${tp_tag}_Alpha${alpha_tag}

                echo "${task_name}: Unlearning using ${trainer} (temp=${temp}, params=${tp_tag})"
                # Quick sanity print
                printf "[CHECK] model=%-18s temp=%-6s tp=%-10s task=%s\n" \
                "$model" "$temp" "$tp_tag" "$task_name" "$alpha"
                printf "        trainable_params_regex=%s\n" "$regex_list"

                # CUDA_VISIBLE_DEVICES=0,1 accelerate launch --config_file configs/accelerate/default_config.yaml --main_process_port $MASTER_PORT \
                # src/train.py --config-name=unlearn.yaml \
                # experiment=unlearn/muse/default.yaml \
                # model=${model} \
                # data_split=${data_split} \
                # trainer=${trainer} \
                # task_name=${task_name} \
                # retain_logs_path=saves/eval/muse_${model}_${data_split}_retrain/MUSE_EVAL.json \
                # trainer.args.per_device_train_batch_size=${per_device_train_batch_size} \
                # trainer.args.gradient_accumulation_steps=${gradient_accumulation_steps} \
                # trainer.args.ddp_find_unused_parameters=true \
                # trainer.args.gradient_checkpointing=true \
                # trainer.method_args.retain_loss_type="KL" \
                # trainer.method_args.attention_temp="${temp}" \
                # trainer.method_args.trainable_params_regex="${regex_list}" \
                # trainer.method_args.alpha="${alpha}"

                CUDA_VISIBLE_DEVICES=1 python src/eval.py \
                experiment=eval/muse/default.yaml \
                data_split=${data_split} \
                task_name=${task_name} \
                model=${model} \
                model.model_args.pretrained_model_name_or_path=saves/unlearn/${task_name} \
                paths.output_dir=saves/unlearn/${task_name}/evals \
                retain_logs_path=saves/eval/muse_${model}_${data_split}_retrain/MUSE_EVAL.json
            done
        done
    done
done





# models_and_temps=(
#     # "Llama-3.1-8B-Instruct 0.1"
#     "Llama-3.1-8B-Instruct 3.0"
#     # "Llama-3.2-3B-Instruct 0.25"
#     "Llama-3.2-3B-Instruct 2.0"
# )

# trainers_experiments=(
#     "ATTU_hidden unlearn/tofu/default.yaml"
#     # "ATTU_output unlearn/tofu/default.yaml"
# )

# splits=(
#     "forget01 holdout01 retain99"
#     "forget05 holdout05 retain95"
#     "forget10 holdout10 retain90"
# )

# trainable_params_lists=(
#     "[\"model\\.layers\\.\\d+\\.self_attn\\..*\"]"
#     "[\"model\\.layers\\.\\d+\\.mlp\\..*\"]"
#     "[\".*\"]"
# )

# per_device_train_batch_size=4 # on two gpus would make effective batch size 32
# gradient_accumulation_steps=4


########################################################################################################################
########################################### Unlearn TOFU models ########################################################
########################################################################################################################

# for split in "${splits[@]}"; do
#     forget_split=$(echo $split | cut -d' ' -f1)
#     holdout_split=$(echo $split | cut -d' ' -f2)
#     retain_split=$(echo $split | cut -d' ' -f3)

#     for mt in "${models_and_temps[@]}"; do
#         # Split "MODEL TEMP"
#         read -r model temp <<< "$mt"
#         temp_tag=${temp//./p}

#         for trainer_experiment in "${trainers_experiments[@]}"; do
#             trainer=$(echo $trainer_experiment | cut -d' ' -f1)
#             experiment=$(echo $trainer_experiment | cut -d' ' -f2)

#             for regex_list in "${trainable_params_lists[@]}"; do
#                 # Decide tag based on which list is chosen
#                 if [[ "$regex_list" == '["model\.layers\.\d+\.self_attn\..*"]' ]]; then
#                 tp_tag="attention"
#                 elif [[ "$regex_list" == '["model\.layers\.\d+\.mlp\..*"]' ]]; then
#                 tp_tag="mlp"
#                 elif [[ "$regex_list" == '[".*"]' ]]; then
#                 tp_tag="all"
#                 else
#                 tp_tag="custom"
#                 fi
                
#                 task_name=tofu_${model}_${forget_split}_${trainer}_T${temp_tag}_P${tp_tag}
#                 model_path=open-unlearning/tofu_${model}_full
#                 echo "${task_name}: Unlearning ${model_path} using ${trainer} (temp=${temp}, params=${tp_tag})"
                

#                 printf "[CHECK] model=%-24s temp=%-6s tp=%-10s task=%s\n" \
#                         "$model" "$temp" "$tp_tag" "$task_name"
#                 printf "        trainable_params_regex=%s\n" "$regex_list"

#                 # Unlearn
#                 CUDA_VISIBLE_DEVICES=0,1 accelerate launch --config_file configs/accelerate/default_config.yaml --main_process_port $MASTER_PORT \
#                 src/train.py --config-name=unlearn.yaml \
#                 experiment=${experiment} \
#                 trainer=${trainer} \
#                 task_name=${task_name} \
#                 model=${model} \
#                 forget_split=${forget_split} \
#                 retain_split=${retain_split} \
#                 model.model_args.pretrained_model_name_or_path=${model_path} \
#                 retain_logs_path=saves/eval/tofu_${model}_${retain_split}/TOFU_EVAL.json \
#                 trainer.args.per_device_train_batch_size=$per_device_train_batch_size \
#                 trainer.args.gradient_accumulation_steps=$gradient_accumulation_steps \
#                 trainer.args.ddp_find_unused_parameters=true \
#                 trainer.args.gradient_checkpointing=true \
#                 trainer.method_args.attention_temp="${temp}" \
#                 trainer.method_args.trainable_params_regex="${regex_list}"
#             done
#         done
#     done
# done





per_device_train_batch_size=4 # on two gpus would make effective batch size 32
gradient_accumulation_steps=4

models_and_temps=(
    # "Llama-3.1-8B-Instruct 0.25"
    "Llama-3.1-8B-Instruct 2.5"
    # "Llama-3.2-3B-Instruct 0.35"
    "Llama-3.2-3B-Instruct 2.0"
)

trainers_experiments=(
    # "ATTU_hidden unlearn/tofu/default.yaml"
    "ATTU_output unlearn/tofu/default.yaml"
)

splits=(
    "forget01 holdout01 retain99"
    "forget05 holdout05 retain95"
    "forget10 holdout10 retain90"
)

trainable_params_lists=(
    # "[\"model\\.layers\\.\\d+\\.self_attn\\..*\"]"
    # "[\"model\\.layers\\.\\d+\\.mlp\\..*\"]"
    "[\".*\"]"
)

alpha=0.2
alpha_tag=${alpha//./p}


for split in "${splits[@]}"; do
    forget_split=$(echo $split | cut -d' ' -f1)
    holdout_split=$(echo $split | cut -d' ' -f2)
    retain_split=$(echo $split | cut -d' ' -f3)

    for mt in "${models_and_temps[@]}"; do
        # Split "MODEL TEMP"
        read -r model temp <<< "$mt"
        temp_tag=${temp//./p}

        for trainer_experiment in "${trainers_experiments[@]}"; do
            trainer=$(echo $trainer_experiment | cut -d' ' -f1)
            experiment=$(echo $trainer_experiment | cut -d' ' -f2)

            for regex_list in "${trainable_params_lists[@]}"; do
                # Decide tag based on which list is chosen
                if [[ "$regex_list" == '["model\.layers\.\d+\.self_attn\..*"]' ]]; then
                tp_tag="attention"
                elif [[ "$regex_list" == '["model\.layers\.\d+\.mlp\..*"]' ]]; then
                tp_tag="mlp"
                elif [[ "$regex_list" == '[".*"]' ]]; then
                tp_tag="all"
                else
                tp_tag="custom"
                fi
                
                task_name=tofu_${model}_${forget_split}_${trainer}_T${temp_tag}_P${tp_tag}_Alpha${alpha_tag}
                model_path=open-unlearning/tofu_${model}_full
                echo "${task_name}: Unlearning ${model_path} using ${trainer} (temp=${temp}, params=${tp_tag})"
                

                printf "[CHECK] model=%-24s temp=%-6s tp=%-10s task=%s\n" \
                        "$model" "$temp" "$tp_tag" "$task_name" "$alpha"
                printf "        trainable_params_regex=%s\n" "$regex_list"

                # # Unlearn
                # CUDA_VISIBLE_DEVICES=0,1 accelerate launch --config_file configs/accelerate/default_config.yaml --main_process_port $MASTER_PORT \
                # src/train.py --config-name=unlearn.yaml \
                # experiment=${experiment} \
                # trainer=${trainer} \
                # task_name=${task_name} \
                # model=${model} \
                # forget_split=${forget_split} \
                # retain_split=${retain_split} \
                # model.model_args.pretrained_model_name_or_path=${model_path} \
                # retain_logs_path=saves/eval/tofu_${model}_${retain_split}/TOFU_EVAL.json \
                # trainer.args.per_device_train_batch_size=$per_device_train_batch_size \
                # trainer.args.gradient_accumulation_steps=$gradient_accumulation_steps \
                # trainer.args.ddp_find_unused_parameters=true \
                # trainer.args.gradient_checkpointing=true \
                # trainer.method_args.attention_temp="${temp}" \
                # trainer.method_args.trainable_params_regex="${regex_list}" \
                # trainer.method_args.retain_loss_type="NLL" \
                # trainer.method_args.alpha="${alpha}"

                # Eval
                CUDA_VISIBLE_DEVICES=1 python src/eval.py \
                experiment=eval/tofu/default.yaml \
                forget_split=${forget_split} \
                holdout_split=${holdout_split} \
                model=${model} \
                task_name=${task_name} \
                model.model_args.pretrained_model_name_or_path=saves/unlearn/${task_name} \
                paths.output_dir=saves/unlearn/${task_name}/evals \
                retain_logs_path=saves/eval/tofu_${model}_${retain_split}/TOFU_EVAL.json
            done
        done
    done
done