MASTER_PORT=$((RANDOM % 50001 + 10000))


forget_losses=(
    GA+GD
    NPO+GD
    IDK+GD
    DPO+GD
    GA+KL
    NPO+KL
    IDK+KL
    DPO+KL
)

learning_rates=(
    1e-5
    # 2e-6
    5e-6
)

mask=true
fix_ref_model=false

split=forget
retain=neighbor

use_LoRA=false
forget_coeff=1.0
regularization_coeff=1.0

# evluate at each unlearning epoch
save_steps=last
eval_steps=(last)

save_checkpoint=false

save_root=results/real_world

num_epochs=5
for forget_loss in ${forget_losses[@]}; do
    for lr in ${learning_rates[@]}; do
        COMMON="use_LoRA=$use_LoRA forget_coeff=$forget_coeff regularization_coeff=$regularization_coeff lr=$lr split=$split forget_loss=$forget_loss num_epochs=$num_epochs \
            mask=$mask fix_ref_model=$fix_ref_model save_root=$save_root save_checkpoint=$save_checkpoint"
        CUDA_VISIBLE_DEVICES=0,1 torchrun --nproc_per_node=2 --master_port=$MASTER_PORT \
                real_world_unlearn.py \
                --config-name=real_world.yaml \
                save_steps=$save_steps \
                $COMMON
        for step in ${eval_steps[@]}; do
            CUDA_VISIBLE_DEVICES=0,1 python \
                    real_world_eval.py \
                    --config-name=real_world.yaml \
                    eval_unlearn_step=$step \
                    $COMMON
        done
    done
done

num_epochs=3
for forget_loss in ${forget_losses[@]}; do
    for lr in ${learning_rates[@]}; do
        COMMON="use_LoRA=$use_LoRA forget_coeff=$forget_coeff regularization_coeff=$regularization_coeff lr=$lr split=$split forget_loss=$forget_loss num_epochs=$num_epochs \
            mask=$mask fix_ref_model=$fix_ref_model save_root=$save_root save_checkpoint=$save_checkpoint"
        CUDA_VISIBLE_DEVICES=0,1 torchrun --nproc_per_node=2 --master_port=$MASTER_PORT \
                real_world_unlearn.py \
                --config-name=real_world.yaml \
                save_steps=$save_steps \
                $COMMON
        for step in ${eval_steps[@]}; do
            CUDA_VISIBLE_DEVICES=0,1 python \
                    real_world_eval.py \
                    --config-name=real_world.yaml \
                    eval_unlearn_step=$step \
                    $COMMON
        done
    done
done




MASTER_PORT=$((RANDOM % 50001 + 10000))


forget_losses=(
    IDK+AP
)

learning_rates=(
    1e-5
    # 2e-6
    # 5e-6
)

mask=true
mask_template=true

fix_ref_model=false

split=forget
retain=neighbor

use_LoRA=false
forget_coeff=1.0
regularization_coeff=1.0

# evluate at each unlearning epoch
save_steps=last
eval_steps=(last)

downstream=true
save_checkpoint=true

save_root=results/real_world

num_epochs=5
for forget_loss in ${forget_losses[@]}; do
    for lr in ${learning_rates[@]}; do
        COMMON="use_LoRA=$use_LoRA forget_coeff=$forget_coeff regularization_coeff=$regularization_coeff lr=$lr split=$split forget_loss=$forget_loss num_epochs=$num_epochs \
            mask=$mask fix_ref_model=$fix_ref_model save_root=$save_root save_checkpoint=$save_checkpoint downstream=$downstream"
        CUDA_VISIBLE_DEVICES=0,1 torchrun --nproc_per_node=2 --master_port=$MASTER_PORT \
                real_world_unlearn.py \
                --config-name=real_world.yaml \
                save_steps=$save_steps \
                $COMMON
        for step in ${eval_steps[@]}; do
            CUDA_VISIBLE_DEVICES=0,1 python \
                    real_world_eval.py \
                    --config-name=real_world.yaml \
                    eval_unlearn_step=$step \
                    $COMMON
        done
    done
done



MASTER_PORT=$((RANDOM % 50001 + 10000))


forget_losses=(
    ME+GD
    # ME+KL
)

learning_rates=(
    # 1e-5
    # 2e-6
    5e-6
)

mask=false
mask_template=true

fix_ref_model=false

split=forget
retain=neighbor

use_LoRA=false
forget_coeff=0.5
regularization_coeff=1.0

# evluate at each unlearning epoch
save_steps=last
eval_steps=(last)

downstream=true
save_checkpoint=true

save_root=results/real_world

num_epochs=5
for forget_loss in ${forget_losses[@]}; do
    for lr in ${learning_rates[@]}; do
        COMMON="use_LoRA=$use_LoRA forget_coeff=$forget_coeff regularization_coeff=$regularization_coeff lr=$lr split=$split forget_loss=$forget_loss num_epochs=$num_epochs \
            mask=$mask fix_ref_model=$fix_ref_model save_root=$save_root save_checkpoint=$save_checkpoint downstream=$downstream"
        CUDA_VISIBLE_DEVICES=0,1 torchrun --nproc_per_node=2 --master_port=$MASTER_PORT \
                real_world_unlearn.py \
                --config-name=real_world.yaml \
                save_steps=$save_steps \
                $COMMON
        for step in ${eval_steps[@]}; do
            CUDA_VISIBLE_DEVICES=0,1 python \
                    real_world_eval.py \
                    --config-name=real_world.yaml \
                    eval_unlearn_step=$step \
                    $COMMON
        done
    done
done






MASTER_PORT=$((RANDOM % 50001 + 10000))


forget_losses=(
    # attn+GD
    attn+KL
)

learning_rates=(
    # 1e-5
    # 2e-6
    5e-6
)

attention_temp_list=(
    # 2.0
    # 2.3
    # 2.5
    # 3.0
    # 2.8
    2.5
)

mask=true
mask_template=true

fix_ref_model=false

split=forget
retain=neighbor

use_LoRA=false
forget_coeff=0.05
regularization_coeff=1.0

# evluate at each unlearning epoch
save_steps=last
eval_steps=(last)

downstream=true
save_checkpoint=false

save_root=results/real_world

num_epochs=5
for attention_temp in ${attention_temp_list[@]}; do
    for forget_loss in ${forget_losses[@]}; do
        for lr in ${learning_rates[@]}; do
            COMMON="use_LoRA=$use_LoRA forget_coeff=$forget_coeff regularization_coeff=$regularization_coeff lr=$lr split=$split forget_loss=$forget_loss num_epochs=$num_epochs \
                mask=$mask fix_ref_model=$fix_ref_model save_root=$save_root save_checkpoint=$save_checkpoint downstream=$downstream attention_temp=$attention_temp"
            CUDA_VISIBLE_DEVICES=0,1 torchrun --nproc_per_node=2 --master_port=$MASTER_PORT \
                    real_world_unlearn.py \
                    --config-name=real_world.yaml \
                    save_steps=$save_steps \
                    $COMMON
            for step in ${eval_steps[@]}; do
                CUDA_VISIBLE_DEVICES=0,1 python \
                        real_world_eval.py \
                        --config-name=real_world.yaml \
                        eval_unlearn_step=$step \
                        $COMMON
            done
        done
    done
done