#!/bin/bash


export MASTER_PORT=$(python -c "import socket; s=socket.socket(); s.bind(('', 0)); print(s.getsockname()[1]); s.close()")
echo "Master Port: $MASTER_PORT"


# #########################################################
# #################### MUSE Unlearning ####################
# #########################################################

per_device_train_batch_size=4
gradient_accumulation_steps=4

models_and_temps=(
    "Llama-2-7b-hf 0.5"
    "Llama-2-7b-hf 2.0"
)

trainers=(
    "ATTU_output"
)

trainable_params_lists=(
    "[\".*\"]"
    "[\"model\\.layers\\.\\d+\\.mlp\\..*\"]"
    "[\"model\\.layers\\.\\d+\\.self_attn\\..*\"]"
)

data_splits=(
    "News"
    "Books"
)


for data_split in "${data_splits[@]}"; do
    for mt in "${models_and_temps[@]}"; do
        # Split "MODEL TEMP"
        read -r model temp <<< "$mt"
        # Safe tag for filenames: 0.5 -> 0p5
        temp_tag=${temp//./p}
        for trainer in "${trainers[@]}"; do
            for regex_list in "${trainable_params_lists[@]}"; do
                # Tag which params are trainable
                if [[ "$regex_list" == '["model\.layers\.\d+\.self_attn\..*"]' ]]; then
                tp_tag="attention"
                elif [[ "$regex_list" == '["model\.layers\.\d+\.mlp\..*"]' ]]; then
                tp_tag="mlp"
                elif [[ "$regex_list" == '[".*"]' ]]; then
                tp_tag="all"
                else
                tp_tag="custom"
                fi

                # task_name=muse_${model}_${data_split}_${trainer}
                task_name=muse_${model}_${data_split}_${trainer}_T${temp_tag}_P${tp_tag}

                echo "${task_name}: Unlearning using ${trainer} (temp=${temp}, params=${tp_tag})"
                # Quick sanity print
                printf "[CHECK] model=%-18s temp=%-6s tp=%-10s task=%s\n" \
                "$model" "$temp" "$tp_tag" "$task_name"
                printf "        trainable_params_regex=%s\n" "$regex_list"

                CUDA_VISIBLE_DEVICES=0,1 accelerate launch --config_file configs/accelerate/default_config.yaml --main_process_port $MASTER_PORT \
                src/train.py --config-name=unlearn.yaml \
                experiment=unlearn/muse/default.yaml \
                model=${model} \
                data_split=${data_split} \
                trainer=${trainer} \
                task_name=${task_name} \
                retain_logs_path=saves/eval/muse_${model}_${data_split}_retrain/MUSE_EVAL.json \
                trainer.args.per_device_train_batch_size=${per_device_train_batch_size} \
                trainer.args.gradient_accumulation_steps=${gradient_accumulation_steps} \
                trainer.args.ddp_find_unused_parameters=true \
                trainer.args.gradient_checkpointing=true \
                trainer.method_args.retain_loss_type="KL" \
                trainer.method_args.attention_temp="${temp}" \
                trainer.method_args.trainable_params_regex="${regex_list}"
            done
        done
    done
done



models_and_temps=(
    "Llama-2-7b-hf 0.3"
    "Llama-2-7b-hf 2.0"
)

trainers=(
    "ATTU_hidden"
)

for data_split in "${data_splits[@]}"; do
    for mt in "${models_and_temps[@]}"; do
        # Split "MODEL TEMP"
        read -r model temp <<< "$mt"
        # Safe tag for filenames: 0.5 -> 0p5
        temp_tag=${temp//./p}
        for trainer in "${trainers[@]}"; do
            for regex_list in "${trainable_params_lists[@]}"; do
                # Tag which params are trainable
                if [[ "$regex_list" == '["model\.layers\.\d+\.self_attn\..*"]' ]]; then
                tp_tag="attention"
                elif [[ "$regex_list" == '["model\.layers\.\d+\.mlp\..*"]' ]]; then
                tp_tag="mlp"
                elif [[ "$regex_list" == '[".*"]' ]]; then
                tp_tag="all"
                else
                tp_tag="custom"
                fi

                # task_name=muse_${model}_${data_split}_${trainer}
                task_name=muse_${model}_${data_split}_${trainer}_T${temp_tag}_P${tp_tag}

                echo "${task_name}: Unlearning using ${trainer} (temp=${temp}, params=${tp_tag})"
                # Quick sanity print
                printf "[CHECK] model=%-18s temp=%-6s tp=%-10s task=%s\n" \
                "$model" "$temp" "$tp_tag" "$task_name"
                printf "        trainable_params_regex=%s\n" "$regex_list"

                CUDA_VISIBLE_DEVICES=0,1 accelerate launch --config_file configs/accelerate/default_config.yaml --main_process_port $MASTER_PORT \
                src/train.py --config-name=unlearn.yaml \
                experiment=unlearn/muse/default.yaml \
                model=${model} \
                data_split=${data_split} \
                trainer=${trainer} \
                task_name=${task_name} \
                retain_logs_path=saves/eval/muse_${model}_${data_split}_retrain/MUSE_EVAL.json \
                trainer.args.per_device_train_batch_size=${per_device_train_batch_size} \
                trainer.args.gradient_accumulation_steps=${gradient_accumulation_steps} \
                trainer.args.ddp_find_unused_parameters=true \
                trainer.args.gradient_checkpointing=true \
                trainer.method_args.attention_temp="${temp}" \
                trainer.method_args.trainable_params_regex="${regex_list}"
            done
        done
    done
done

# #########################################################
# #################### MUSE Evaluation ####################
# #########################################################


models_and_temps=(
    "Llama-2-7b-hf 0.5"
    "Llama-2-7b-hf 2.0"
)

trainers=(
    "ATTU_output"
)

trainable_params_lists=(
    "[\"model\\.layers\\.\\d+\\.self_attn\\..*\"]"
    "[\"model\\.layers\\.\\d+\\.mlp\\..*\"]"
    "[\".*\"]"
)

data_splits=(
    "News"
    "Books"
)


for data_split in "${data_splits[@]}"; do
    for mt in "${models_and_temps[@]}"; do
        # Split "MODEL TEMP"
        read -r model temp <<< "$mt"
        # Safe tag for filenames: 0.5 -> 0p5
        temp_tag=${temp//./p}
        for trainer in "${trainers[@]}"; do
            for regex_list in "${trainable_params_lists[@]}"; do
                # Tag which params are trainable
                if [[ "$regex_list" == '["model\.layers\.\d+\.self_attn\..*"]' ]]; then
                tp_tag="attention"
                elif [[ "$regex_list" == '["model\.layers\.\d+\.mlp\..*"]' ]]; then
                tp_tag="mlp"
                elif [[ "$regex_list" == '[".*"]' ]]; then
                tp_tag="all"
                else
                tp_tag="custom"
                fi

                # task_name=muse_${model}_${data_split}_${trainer}
                task_name=muse_${model}_${data_split}_${trainer}_T${temp_tag}_P${tp_tag}

                echo "${task_name}: Unlearning ${model} using ${trainer} (temp=${temp}, params=${tp_tag})"
                # Quick sanity print
                printf "[CHECK] model=%-18s temp=%-6s tp=%-10s task=%s\n" \
                "$model" "$temp" "$tp_tag" "$task_name"
                printf "        trainable_params_regex=%s\n" "$regex_list"

                CUDA_VISIBLE_DEVICES=1 python src/eval.py \
                experiment=eval/muse/default.yaml \
                data_split=${data_split} \
                task_name=${task_name} \
                model=${model} \
                model.model_args.pretrained_model_name_or_path=saves/unlearn/${task_name} \
                paths.output_dir=saves/unlearn/${task_name}/evals \
                retain_logs_path=saves/eval/muse_${model}_${data_split}_retrain/MUSE_EVAL.json
            done
        done
    done
done






models_and_temps=(
    "Llama-2-7b-hf 0.3"
    "Llama-2-7b-hf 2.0"
)

trainers=(
    "ATTU_hidden"
)


for data_split in "${data_splits[@]}"; do
    for mt in "${models_and_temps[@]}"; do
        # Split "MODEL TEMP"
        read -r model temp <<< "$mt"
        # Safe tag for filenames: 0.5 -> 0p5
        temp_tag=${temp//./p}
        for trainer in "${trainers[@]}"; do
            for regex_list in "${trainable_params_lists[@]}"; do
                # Tag which params are trainable
                if [[ "$regex_list" == '["model\.layers\.\d+\.self_attn\..*"]' ]]; then
                tp_tag="attention"
                elif [[ "$regex_list" == '["model\.layers\.\d+\.mlp\..*"]' ]]; then
                tp_tag="mlp"
                elif [[ "$regex_list" == '[".*"]' ]]; then
                tp_tag="all"
                else
                tp_tag="custom"
                fi

                # task_name=muse_${model}_${data_split}_${trainer}
                task_name=muse_${model}_${data_split}_${trainer}_T${temp_tag}_P${tp_tag}

                echo "${task_name}: Unlearning ${model} using ${trainer} (temp=${temp}, params=${tp_tag})"
                # Quick sanity print
                printf "[CHECK] model=%-18s temp=%-6s tp=%-10s task=%s\n" \
                    "$model" "$temp" "$tp_tag" "$task_name"
                printf "        trainable_params_regex=%s\n" "$regex_list"

                CUDA_VISIBLE_DEVICES=1 python src/eval.py \
                experiment=eval/muse/default.yaml \
                data_split=${data_split} \
                task_name=${task_name} \
                model=${model} \
                model.model_args.pretrained_model_name_or_path=saves/unlearn/${task_name} \
                paths.output_dir=saves/unlearn/${task_name}/evals \
                retain_logs_path=saves/eval/muse_${model}_${data_split}_retrain/MUSE_EVAL.json
            done
        done
    done
done