from torch_geometric.graphgym.register import register_config
from yacs.config import CfgNode as CN
from pydantic.dataclasses import dataclass
import torch


@register_config("cfg_dataset_multi")
def set_cfg_dataset_multi(cfg):
    cfg.dataset_multi = CN()

    cfg.dataset_multi.name_list = []
    cfg.dataset_multi.use_synthetic = False
    cfg.dataset_multi.synthetic_data_dir = [
        "/synthetic_data"
    ]  # change dir later on

    cfg.dataset_multi.num_synthetic_samples = 100
    cfg.dataset_multi.syn_graph_config = []

    # setup datasets and tasks
    cfg.imdb_binary = CN()
    cfg.reddit_binary = CN()
    cfg.collab = CN()
    cfg.texas = CN()
    cfg.wisconsin = CN()
    cfg.chameleon = CN()
    cfg.squirrel = CN()
    cfg.actor = CN()
    cfg.planetoid_cora = CN()
    cfg.planetoid_citeseer = CN()
    cfg.planetoid_pubmed = CN()
    cfg.amazon_comp = CN()
    cfg.amazon_photo = CN()
    cfg.coauthor_cs = CN()
    cfg.coauthor_physics = CN()
    cfg.ogbn_arxiv = CN()
    cfg.ogbn_products = CN()
    cfg.ogbn_mag = CN()
    cfg.reddit = CN()
    cfg.reddit2 = CN()
    cfg.flickr = CN()
    cfg.yelp = CN()
    cfg.amazon_products = CN()
    cfg.agd_wiki = CN()
    cfg.agd_blog_catalog = CN()
    cfg.agd_ppi = CN()
    cfg.agd_flickr = CN()
    cfg.agd_facebook = CN()
    cfg.agd_tweibo = CN()
    cfg.agd_mag = CN()
    cfg.wiki_cs = CN()

    cfg.hgd_roman_empire = CN()
    cfg.hgd_amazon_ratings = CN()
    cfg.hgd_minesweeper = CN()
    cfg.hgd_tolokers = CN()
    cfg.hgd_questions = CN()

    cfg.twitch_de = CN()
    cfg.twitch_en = CN()
    cfg.twitch_es = CN()
    cfg.twitch_fr = CN()
    cfg.twitch_pt = CN()
    cfg.twitch_ru = CN()

    cfg.deezer_europe = CN()
    cfg.github = CN()
    cfg.facebook_page_page = CN()
    cfg.last_fm_asia = CN()

    cfg.airports_usa = CN()
    cfg.airports_brazil = CN()
    cfg.airports_europe = CN()

    cfg.pol_blogs = CN()
    cfg.email_eu_core = CN()

    cfg.lxd_penn94 = CN()
    cfg.lxd_reed98 = CN()
    cfg.lxd_amherst41 = CN()
    cfg.lxd_cornell5 = CN()
    cfg.lxd_johnshopkins55 = CN()
    cfg.lxd_genius = CN()

    cfg.karate_club = CN()
    cfg.nell = CN()

    cfg.citationfull_cora = CN()
    cfg.citationfull_cora_ml = CN()
    cfg.citationfull_citeseer = CN()
    cfg.citationfull_pubmed = CN()
    cfg.citationfull_dblp = CN()

    cfg.nr_aids = CN()
    cfg.nr_ba_1_10_60_l5 = CN()
    cfg.nr_ba_2_24_60_l2 = CN()
    cfg.nr_bzr = CN()
    cfg.nr_cl_100k_1d8_l9 = CN()
    cfg.nr_cl_10k_1d8_l5 = CN()
    cfg.nr_cl_10m_1d8_l5 = CN()
    cfg.nr_cox2 = CN()
    cfg.nr_dblp_v1 = CN()
    cfg.nr_dd = CN()
    cfg.nr_dd199 = CN()
    cfg.nr_dd21 = CN()
    cfg.nr_dd242 = CN()
    cfg.nr_dd244 = CN()
    cfg.nr_dd349 = CN()
    cfg.nr_dd497 = CN()
    cfg.nr_dd6 = CN()
    cfg.nr_dd68 = CN()
    cfg.nr_dd687 = CN()
    cfg.nr_dhfr = CN()
    cfg.nr_enzymes = CN()
    cfg.nr_enzymes118 = CN()
    cfg.nr_enzymes123 = CN()
    cfg.nr_enzymes295 = CN()
    cfg.nr_enzymes296 = CN()
    cfg.nr_enzymes297 = CN()
    cfg.nr_enzymes8 = CN()
    cfg.nr_er_avgdeg10_100k_l2 = CN()
    cfg.nr_er_avgdeg10_100k_l5 = CN()
    cfg.nr_er_avgdeg10_1m_l2 = CN()
    cfg.nr_er_avgdeg10_1m_l5 = CN()
    cfg.nr_kki = CN()
    cfg.nr_msrc_21 = CN()
    cfg.nr_msrc_21c = CN()
    cfg.nr_msrc_9 = CN()
    cfg.nr_mutagenicity = CN()
    cfg.nr_nci1 = CN()
    cfg.nr_nci109 = CN()
    cfg.nr_ohsu = CN()
    cfg.nr_plc_40_30_l5 = CN()
    cfg.nr_plc_60_30_l2 = CN()
    cfg.nr_proteins_full = CN()
    cfg.nr_ptc_fm = CN()
    cfg.nr_ptc_fr = CN()
    cfg.nr_ptc_mm = CN()
    cfg.nr_ptc_mr = CN()
    cfg.nr_peking_1 = CN()
    cfg.nr_pubmed = CN()
    cfg.nr_sw_10000_6_0d3_l2 = CN()
    cfg.nr_sw_10000_6_0d3_l5 = CN()
    cfg.nr_synthetic = CN()
    cfg.nr_terroristrel = CN()
    cfg.nr_tox21_ahr = CN()
    cfg.nr_tox21_ar = CN()
    cfg.nr_tox21_ar_lbd = CN()
    cfg.nr_tox21_are = CN()
    cfg.nr_tox21_atad5 = CN()
    cfg.nr_tox21_er = CN()
    cfg.nr_tox21_er_lbd = CN()
    cfg.nr_tox21_hse = CN()
    cfg.nr_tox21_mmp = CN()
    cfg.nr_tox21_ppar_gamma = CN()
    cfg.nr_tox21_aromatase = CN()
    cfg.nr_tox21_p53 = CN()
    cfg.nr_tox21_p53 = CN()
    cfg.nr_cora = CN()
    cfg.nr_fb_cmu_carnegie49 = CN()
    cfg.nr_gene = CN()
    cfg.nr_proteins_all = CN()
    cfg.nr_reality_call = CN()
    cfg.nr_soc_blogcatalog_asu = CN()
    cfg.nr_soc_flickr_asu = CN()
    cfg.nr_soc_youtube_asu = CN()
    cfg.nr_soc_political_retweet = CN()
    cfg.nr_webkb_wisc = CN()

    cfg.snap_pokec = CN()
    cfg.snap_patents = CN()

    for name in [
        "texas",
        "wisconsin",
        "chameleon",
        "squirrel",
        "actor",
        "amazon_comp",
        "amazon_photo",
        "coauthor_cs",
        "coauthor_physics",
        "ogbn_arxiv",
        "ogbn_mag",
        "reddit",
        "reddit2",
        "flickr",
        "yelp",
        "amazon_products",
        "agd_wiki",
        "agd_blog_catalog",
        "agd_ppi",
        "agd_flickr",
        "agd_facebook",
        "agd_tweibo",
        "agd_mag",
        "wiki_cs",
        "hgd_roman_empire",
        "hgd_amazon_ratings",
        "hgd_minesweeper",
        "hgd_tolokers",
        "hgd_questions",
        "twitch_de",
        "twitch_en",
        "twitch_es",
        "twitch_fr",
        "twitch_pt",
        "twitch_ru",
        "deezer_europe",
        "github",
        "facebook_page_page",
        "last_fm_asia",
        "airports_usa",
        "airports_brazil",
        "airports_europe",
        "pol_blogs",
        "email_eu_core",
        "lxd_penn94",
        "lxd_reed98",
        "lxd_amherst41",
        "lxd_cornell5",
        "lxd_johnshopkins55",
        "lxd_genius",
        "karate_club",
        "planetoid_cora",
        "planetoid_citeseer",
        "planetoid_pubmed",
        "nell",
        "citationfull_cora",
        "citationfull_cora_ml",
        "citationfull_citeseer",
        "citationfull_pubmed",
        "citationfull_dblp",
        # network repository datasets
        "nr_aids",
        "nr_ba_1_10_60_l5",
        "nr_ba_2_24_60_l2",
        "nr_bzr",
        "nr_cl_100k_1d8_l9",
        "nr_cl_10k_1d8_l5",
        "nr_cl_10m_1d8_l5",
        "nr_cox2",
        "nr_dblp_v1",
        "nr_dd",
        "nr_dd199",
        "nr_dd21",
        "nr_dd242",
        "nr_dd244",
        "nr_dd349",
        "nr_dd497",
        "nr_dd6",
        "nr_dd68",
        "nr_dd687",
        "nr_dhfr",
        "nr_enzymes",
        "nr_enzymes118",
        "nr_enzymes123",
        "nr_enzymes295",
        "nr_enzymes296",
        "nr_enzymes297",
        "nr_enzymes8",
        "nr_er_avgdeg10_100k_l2",
        "nr_er_avgdeg10_100k_l5",
        "nr_er_avgdeg10_1m_l2",
        "nr_er_avgdeg10_1m_l5",
        "nr_kki",
        "nr_msrc_21",
        "nr_msrc_21c",
        "nr_msrc_9",
        "nr_mutagenicity",
        "nr_nci1",
        "nr_nci109",
        "nr_ohsu",
        "nr_plc_40_30_l5",
        "nr_plc_60_30_l2",
        "nr_proteins_full",
        "nr_ptc_fm",
        "nr_ptc_fr",
        "nr_ptc_mm",
        "nr_ptc_mr",
        "nr_peking_1",
        "nr_pubmed",
        "nr_sw_10000_6_0d3_l2",
        "nr_sw_10000_6_0d3_l5",
        "nr_synthetic",
        "nr_terroristrel",
        "nr_tox21_ahr",
        "nr_tox21_ar",
        "nr_tox21_ar_lbd",
        "nr_tox21_are",
        "nr_tox21_atad5",
        "nr_tox21_er",
        "nr_tox21_er_lbd",
        "nr_tox21_hse",
        "nr_tox21_mmp",
        "nr_tox21_ppar_gamma",
        "nr_tox21_aromatase",
        "nr_tox21_p53",
        "nr_tox21_p53",
        "nr_cora",
        "nr_fb_cmu_carnegie49",
        "nr_gene",
        "nr_proteins_all",
        "nr_reality_call",
        "nr_soc_blogcatalog_asu",
        "nr_soc_flickr_asu",
        "nr_soc_youtube_asu",
        "nr_soc_political_retweet",
        "nr_webkb_wisc",
        "snap_pokec",
        "snap_patents",
    ]:
        data_cfg = getattr(cfg, name)
        data_cfg.enable = False  # datasets are not enabled by default
        data_cfg.dir_with_error = "/dev/shm/graph-datasets/real_datasets/datasets"
        data_cfg.dir = "/dev/shm/graph-datasets/real_datasets/datasets"
        data_cfg.graph_ratio_in_epoch = 1.0

    cfg.imdb_binary.dataset_name = "IMDB-BINARY"
    cfg.imdb_binary.format = "PyG-TUDataset"
    cfg.imdb_binary.task = "graph"
    cfg.imdb_binary.task_type = "classification"
    cfg.imdb_binary.loss_fun = "cross_entropy"
    cfg.imdb_binary.task_dim = 1
    cfg.imdb_binary.split_mode = "cv-kfold-10"
    cfg.imdb_binary.split_dir = "tests/splits"
    cfg.imdb_binary.split_index = 0

    cfg.reddit_binary.dataset_name = "REDDIT-BINARY"
    cfg.reddit_binary.format = "PyG-TUDataset"
    cfg.reddit_binary.task = "graph"
    cfg.reddit_binary.task_type = "classification"
    cfg.reddit_binary.loss_fun = "cross_entropy"
    cfg.reddit_binary.task_dim = 1
    cfg.reddit_binary.split_mode = "cv-kfold-10"
    cfg.reddit_binary.split_dir = "tests/splits"
    cfg.reddit_binary.split_index = 0

    cfg.collab.dataset_name = "COLLAB"
    cfg.collab.format = "PyG-TUDataset"
    cfg.collab.task = "graph"
    cfg.collab.task_type = "classification"
    cfg.collab.loss_fun = "cross_entropy"
    cfg.collab.task_dim = 3
    cfg.collab.split_mode = "cv-kfold-10"
    cfg.collab.split_dir = "tests/splits"
    cfg.collab.split_index = 0

    cfg.texas.dataset_name = "texas"
    cfg.texas.format = "PyG-WebKB"
    cfg.texas.task = "node"
    cfg.texas.task_type = "classification"
    cfg.texas.loss_fun = "cross_entropy"
    cfg.texas.task_dim = 5
    cfg.texas.split_mode = "standard"
    cfg.texas.transductive = True
    cfg.texas.split_index = 0
    cfg.texas.feat_dim = 1703
    cfg.texas.hidden_dim = 128
    cfg.texas.activate_fn = "torch.nn.ReLU()"

    cfg.wisconsin.dataset_name = "wisconsin"
    cfg.wisconsin.format = "PyG-WebKB"
    cfg.wisconsin.task = "node"
    cfg.wisconsin.task_type = "classification"
    cfg.wisconsin.loss_fun = "cross_entropy"
    cfg.wisconsin.task_dim = 5
    cfg.wisconsin.split_mode = "standard"
    cfg.wisconsin.transductive = True
    cfg.wisconsin.split_index = 0
    cfg.wisconsin.feat_dim = 1703
    cfg.wisconsin.hidden_dim = 128
    cfg.wisconsin.activate_fn = "torch.nn.ReLU()"

    cfg.chameleon.dataset_name = "chameleon"
    cfg.chameleon.format = "PyG-WikipediaNetwork"
    cfg.chameleon.task = "node"
    cfg.chameleon.task_type = "classification"
    cfg.chameleon.loss_fun = "cross_entropy"
    cfg.chameleon.task_dim = 5
    cfg.chameleon.split_mode = "standard"
    cfg.chameleon.transductive = True
    cfg.chameleon.split_index = 0
    cfg.chameleon.feat_dim = 2325
    cfg.chameleon.hidden_dim = 64
    cfg.chameleon.activate_fn = "torch.nn.ReLU()"

    cfg.squirrel.dataset_name = "squirrel"
    cfg.squirrel.format = "PyG-WikipediaNetwork"
    cfg.squirrel.task = "node"
    cfg.squirrel.task_type = "classification"
    cfg.squirrel.loss_fun = "cross_entropy"
    cfg.squirrel.task_dim = 5
    cfg.squirrel.split_mode = "standard"
    cfg.squirrel.transductive = True
    cfg.squirrel.split_index = 0
    cfg.squirrel.feat_dim = 2089
    cfg.squirrel.hidden_dim = 64
    cfg.squirrel.activate_fn = "torch.nn.ReLU()"

    cfg.actor.dataset_name = "actor"
    cfg.actor.format = "PyG-Actor"
    cfg.actor.task = "node"
    cfg.actor.task_type = "classification"
    cfg.actor.loss_fun = "cross_entropy"
    cfg.actor.task_dim = 5
    cfg.actor.split_mode = "standard"
    cfg.actor.transductive = True
    cfg.actor.split_index = 0
    cfg.actor.feat_dim = 932
    cfg.actor.hidden_dim = 64
    cfg.actor.activate_fn = "torch.nn.ReLU()"

    cfg.amazon_comp.dataset_name = "Amazon-Computers"
    cfg.amazon_comp.format = "PyG"
    cfg.amazon_comp.task = "node"
    cfg.amazon_comp.task_type = "classification"
    cfg.amazon_comp.loss_fun = "cross_entropy"
    cfg.amazon_comp.task_dim = 10
    cfg.amazon_comp.split_mode = "random"
    cfg.amazon_comp.transductive = True
    cfg.amazon_comp.split_index = [0]
    cfg.amazon_comp.feat_dim = 767
    cfg.amazon_comp.hidden_dim = 256
    cfg.amazon_comp.activate_fn = "torch.nn.ReLU()"
    cfg.amazon_comp.split = [0.6, 0.2, 0.2]

    cfg.amazon_photo.dataset_name = "Amazon-Photo"
    cfg.amazon_photo.format = "PyG"
    cfg.amazon_photo.task = "node"
    cfg.amazon_photo.task_type = "classification"
    cfg.amazon_photo.loss_fun = "cross_entropy"
    cfg.amazon_photo.task_dim = 8
    cfg.amazon_photo.split_mode = "random"
    cfg.amazon_photo.transductive = True
    cfg.amazon_photo.split_index = [0]
    cfg.amazon_photo.feat_dim = 745
    cfg.amazon_photo.hidden_dim = 256
    cfg.amazon_photo.activate_fn = "torch.nn.ReLU()"
    cfg.amazon_photo.split = [0.6, 0.2, 0.2]

    cfg.coauthor_cs.dataset_name = "Coauthor-CS"
    cfg.coauthor_cs.format = "PyG"
    cfg.coauthor_cs.task = "node"
    cfg.coauthor_cs.task_type = "classification"
    cfg.coauthor_cs.loss_fun = "cross_entropy"
    cfg.coauthor_cs.task_dim = 15
    cfg.coauthor_cs.split_mode = "random"
    cfg.coauthor_cs.transductive = True
    cfg.coauthor_cs.split_index = [0]
    cfg.coauthor_cs.feat_dim = 6805
    cfg.coauthor_cs.hidden_dim = 128
    cfg.coauthor_cs.activate_fn = "torch.nn.ReLU()"
    cfg.coauthor_cs.split = [0.6, 0.2, 0.2]

    cfg.coauthor_physics.dataset_name = "Coauthor-Physics"
    cfg.coauthor_physics.format = "PyG"
    cfg.coauthor_physics.task = "node"
    cfg.coauthor_physics.task_type = "classification"
    cfg.coauthor_physics.loss_fun = "cross_entropy"
    cfg.coauthor_physics.task_dim = 5
    cfg.coauthor_physics.split_mode = "random"
    cfg.coauthor_physics.transductive = True
    cfg.coauthor_physics.split_index = [0]
    cfg.coauthor_physics.feat_dim = 8415
    cfg.coauthor_physics.hidden_dim = 128
    cfg.coauthor_physics.activate_fn = "torch.nn.ReLU()"
    cfg.coauthor_physics.split = [0.6, 0.2, 0.2]

    cfg.ogbn_arxiv.dataset_name = "ogbn-arxiv"
    cfg.ogbn_arxiv.format = "OGB"
    cfg.ogbn_arxiv.task = "node"
    cfg.ogbn_arxiv.task_type = "classification"
    cfg.ogbn_arxiv.loss_fun = "cross_entropy"
    cfg.ogbn_arxiv.task_dim = 40
    cfg.ogbn_arxiv.split_mode = "fixed_dataset"
    cfg.ogbn_arxiv.transductive = True
    cfg.ogbn_arxiv.split_index = [0]
    cfg.ogbn_arxiv.feat_dim = 128
    cfg.ogbn_arxiv.hidden_dim = 64
    cfg.ogbn_arxiv.activate_fn = "torch.nn.ReLU()"

    cfg.ogbn_products.dataset_name = "ogbn-products"
    cfg.ogbn_products.format = "OGB"
    cfg.ogbn_products.task = "node"
    cfg.ogbn_products.task_type = "classification"
    cfg.ogbn_products.loss_fun = "cross_entropy"
    cfg.ogbn_products.task_dim = 47
    cfg.ogbn_products.split_mode = "fixed_dataset"
    cfg.ogbn_products.transductive = True
    cfg.ogbn_products.split_index = [0]
    cfg.ogbn_products.feat_dim = 100
    cfg.ogbn_products.hidden_dim = 64
    cfg.ogbn_products.activate_fn = "torch.nn.ReLU()"

    cfg.ogbn_mag.dataset_name = "ogbn-mag"
    cfg.ogbn_mag.format = "OGB"
    cfg.ogbn_mag.task = "node"
    cfg.ogbn_mag.task_type = "classification"
    cfg.ogbn_mag.loss_fun = "cross_entropy"
    cfg.ogbn_mag.task_dim = 40
    cfg.ogbn_mag.split_mode = "fixed_dataset"
    cfg.ogbn_mag.transductive = True
    cfg.ogbn_mag.split_index = [0]
    cfg.ogbn_mag.feat_dim = 128
    cfg.ogbn_mag.hidden_dim = 64
    cfg.ogbn_mag.activate_fn = "torch.nn.ReLU()"

    cfg.reddit.dataset_name = "Reddit"
    cfg.reddit.format = "PyG"
    cfg.reddit.task = "node"
    cfg.reddit.task_type = "classification"
    cfg.reddit.loss_fun = "cross_entropy"
    cfg.reddit.task_dim = 41
    cfg.reddit.split_mode = "standard"
    cfg.reddit.transductive = True
    cfg.reddit.split_index = [0]
    cfg.reddit.feat_dim = 602
    cfg.reddit.hidden_dim = 64
    cfg.reddit.activate_fn = "torch.nn.ReLU()"
    cfg.reddit.num_nodes = 232965
    cfg.reddit.graph_ratio_in_epoch = 0.5
    cfg.reddit.manual_lr = 1.48e-6

    cfg.reddit2.dataset_name = "Reddit2"
    cfg.reddit2.format = "PyG"
    cfg.reddit2.task = "node"
    cfg.reddit2.task_type = "classification"
    cfg.reddit2.loss_fun = "cross_entropy"
    cfg.reddit2.task_dim = 41
    cfg.reddit2.split_mode = "standard"
    cfg.reddit2.transductive = True
    cfg.reddit2.split_index = [0]
    cfg.reddit2.feat_dim = 602
    cfg.reddit2.hidden_dim = 64
    cfg.reddit2.activate_fn = "torch.nn.ReLU()"
    cfg.reddit2.num_nodes = 232965
    cfg.reddit2.graph_ratio_in_epoch = 0.5
    cfg.reddit2.manual_lr = 1.48e-6

    cfg.flickr.dataset_name = "Flickr"
    cfg.flickr.format = "PyG"
    cfg.flickr.task = "node"
    cfg.flickr.task_type = "classification"
    cfg.flickr.loss_fun = "cross_entropy"
    cfg.flickr.task_dim = 7
    cfg.flickr.split_mode = "standard"
    cfg.flickr.transductive = True
    cfg.flickr.split_index = [0]
    cfg.flickr.feat_dim = 500
    cfg.flickr.hidden_dim = 64
    cfg.flickr.activate_fn = "torch.nn.ReLU()"
    cfg.flickr.num_nodes = 89250
    cfg.flickr.manual_lr = 2.16e-6

    cfg.yelp.dataset_name = "Yelp"
    cfg.yelp.format = "PyG"
    cfg.yelp.task = "node"
    cfg.yelp.task_type = "classification"
    cfg.yelp.loss_fun = "cross_entropy"
    cfg.yelp.task_dim = 100
    cfg.yelp.split_mode = "standard"
    cfg.yelp.transductive = True
    cfg.yelp.split_index = [0]
    cfg.yelp.feat_dim = 300
    cfg.yelp.hidden_dim = 64
    cfg.yelp.activate_fn = "torch.nn.ReLU()"
    cfg.yelp.graph_ratio_in_epoch = 0.8
    cfg.yelp.manual_lr = 1.3e-7

    cfg.amazon_products.dataset_name = "AmazonProducts"
    cfg.amazon_products.format = "PyG"
    cfg.amazon_products.task = "node"
    cfg.amazon_products.task_type = "classification"
    cfg.amazon_products.loss_fun = "cross_entropy"
    cfg.amazon_products.task_dim = 107
    cfg.amazon_products.split_mode = "standard"
    cfg.amazon_products.transductive = True
    cfg.amazon_products.split_index = [0]
    cfg.amazon_products.feat_dim = 200
    cfg.amazon_products.hidden_dim = 64
    cfg.amazon_products.activate_fn = "torch.nn.ReLU()"

    cfg.agd_wiki.dataset_name = "AttributedGraphDataset_Wiki"
    cfg.agd_wiki.format = "PyG"
    cfg.agd_wiki.task = "node"
    cfg.agd_wiki.task_type = "classification"
    cfg.agd_wiki.loss_fun = "cross_entropy"
    cfg.agd_wiki.task_dim = 17
    cfg.agd_wiki.split_mode = "random"
    cfg.agd_wiki.transductive = True
    cfg.agd_wiki.split_index = [0]
    cfg.agd_wiki.feat_dim = 4973
    cfg.agd_wiki.hidden_dim = 64
    cfg.agd_wiki.activate_fn = "torch.nn.ReLU()"
    cfg.agd_wiki.split = [0.6, 0.2, 0.2]
    cfg.agd_wiki.num_nodes = 2405
    cfg.agd_wiki.manual_lr = 5.1e-7

    cfg.agd_blog_catalog.dataset_name = "AttributedGraphDataset_BlogCatalog"
    cfg.agd_blog_catalog.format = "PyG"
    cfg.agd_blog_catalog.task = "node"
    cfg.agd_blog_catalog.task_type = "classification"
    cfg.agd_blog_catalog.loss_fun = "cross_entropy"
    cfg.agd_blog_catalog.task_dim = 6
    cfg.agd_blog_catalog.split_mode = "random"
    cfg.agd_blog_catalog.transductive = True
    cfg.agd_blog_catalog.split_index = [0]
    cfg.agd_blog_catalog.feat_dim = 8189
    cfg.agd_blog_catalog.hidden_dim = 64
    cfg.agd_blog_catalog.activate_fn = "torch.nn.ReLU()"
    cfg.agd_blog_catalog.split = [0.6, 0.2, 0.2]
    cfg.agd_blog_catalog.num_nodes = 5196
    cfg.agd_blog_catalog.manual_lr = 4.2e-6

    cfg.agd_ppi.dataset_name = "AttributedGraphDataset_PPI"
    cfg.agd_ppi.format = "PyG"
    cfg.agd_ppi.task = "node"
    cfg.agd_ppi.task_type = "classification"
    cfg.agd_ppi.loss_fun = "cross_entropy"
    cfg.agd_ppi.task_dim = 121
    cfg.agd_ppi.split_mode = "random"
    cfg.agd_ppi.transductive = True
    cfg.agd_ppi.split_index = [0]
    cfg.agd_ppi.feat_dim = 50
    cfg.agd_ppi.hidden_dim = 64
    cfg.agd_ppi.activate_fn = "torch.nn.ReLU()"
    cfg.agd_ppi.split = [0.6, 0.2, 0.2]
    cfg.agd_ppi.manual_lr = 6.6e-7

    cfg.agd_flickr.dataset_name = "AttributedGraphDataset_Flickr"
    cfg.agd_flickr.format = "PyG"
    cfg.agd_flickr.task = "node"
    cfg.agd_flickr.task_type = "classification"
    cfg.agd_flickr.loss_fun = "cross_entropy"
    cfg.agd_flickr.task_dim = 9
    cfg.agd_flickr.split_mode = "random"
    cfg.agd_flickr.transductive = True
    cfg.agd_flickr.split_index = [0]
    cfg.agd_flickr.feat_dim = 12047
    cfg.agd_flickr.hidden_dim = 64
    # cfg.agd_flickr.hidden_dim = 128
    cfg.agd_flickr.activate_fn = "torch.nn.ReLU()"
    cfg.agd_flickr.split = [0.6, 0.2, 0.2]
    cfg.agd_flickr.num_nodes = 7575

    cfg.agd_facebook.dataset_name = "AttributedGraphDataset_Facebook"
    cfg.agd_facebook.format = "PyG"
    cfg.agd_facebook.task = "node"
    cfg.agd_facebook.task_type = "classification"
    cfg.agd_facebook.loss_fun = "cross_entropy"
    cfg.agd_facebook.task_dim = 193
    cfg.agd_facebook.split_mode = "random"
    cfg.agd_facebook.transductive = True
    cfg.agd_facebook.split_index = [0]
    cfg.agd_facebook.feat_dim = 1283
    cfg.agd_facebook.hidden_dim = 64
    # cfg.agd_facebook.hidden_dim = 128
    cfg.agd_facebook.activate_fn = "torch.nn.ReLU()"
    cfg.agd_facebook.split = [0.6, 0.2, 0.2]
    cfg.agd_facebook.num_nodes = 4039
    cfg.agd_facebook.manual_lr = 4.7e-7

    cfg.agd_tweibo.dataset_name = "AttributedGraphDataset_TWeibo"
    cfg.agd_tweibo.format = "PyG"
    cfg.agd_tweibo.task = "node"
    cfg.agd_tweibo.task_type = "classification"
    cfg.agd_tweibo.loss_fun = "cross_entropy"
    cfg.agd_tweibo.task_dim = 193
    cfg.agd_tweibo.split_mode = "random"
    cfg.agd_tweibo.transductive = True
    cfg.agd_tweibo.split_index = [0]
    cfg.agd_tweibo.feat_dim = 1657
    cfg.agd_tweibo.hidden_dim = 128
    cfg.agd_tweibo.activate_fn = "torch.nn.ReLU()"
    cfg.agd_tweibo.split = [0.6, 0.2, 0.2]
    cfg.agd_tweibo.num_nodes = 2320895
    cfg.agd_tweibo.graph_ratio_in_epoch = 0.2

    cfg.agd_mag.dataset_name = "AttributedGraphDataset_MAG"
    cfg.agd_mag.format = "PyG"
    cfg.agd_mag.task = "node"
    cfg.agd_mag.task_type = "classification"
    cfg.agd_mag.loss_fun = "cross_entropy"
    cfg.agd_mag.task_dim = 8
    cfg.agd_mag.split_mode = "random"
    cfg.agd_mag.transductive = True
    cfg.agd_mag.split_index = [0]
    cfg.agd_mag.feat_dim = 1657
    cfg.agd_mag.hidden_dim = 128
    cfg.agd_mag.activate_fn = "torch.nn.ReLU()"
    cfg.agd_mag.split = [0.6, 0.2, 0.2]

    cfg.wiki_cs.dataset_name = "WikiCS"
    cfg.wiki_cs.format = "PyG"
    cfg.wiki_cs.task = "node"
    cfg.wiki_cs.task_type = "classification"
    cfg.wiki_cs.loss_fun = "cross_entropy"
    cfg.wiki_cs.task_dim = 10
    cfg.wiki_cs.split_mode = "standard"
    cfg.wiki_cs.transductive = True
    cfg.wiki_cs.split_index = 0
    cfg.wiki_cs.feat_dim = 300
    cfg.wiki_cs.hidden_dim = 64
    cfg.wiki_cs.activate_fn = "torch.nn.ReLU()"
    cfg.wiki_cs.num_nodes = 11701
    cfg.wiki_cs.manual_lr = 4e-7

    cfg.hgd_roman_empire.dataset_name = "HeterophilousGraphDataset_Roman-empire"
    cfg.hgd_roman_empire.format = "PyG"
    cfg.hgd_roman_empire.task = "node"
    cfg.hgd_roman_empire.task_type = "classification"
    cfg.hgd_roman_empire.loss_fun = "cross_entropy"
    cfg.hgd_roman_empire.task_dim = 18
    cfg.hgd_roman_empire.split_mode = "standard"
    cfg.hgd_roman_empire.transductive = True
    cfg.hgd_roman_empire.split_index = 0
    cfg.hgd_roman_empire.feat_dim = 300
    cfg.hgd_roman_empire.hidden_dim = 64
    cfg.hgd_roman_empire.activate_fn = "torch.nn.ReLU()"
    cfg.hgd_roman_empire.num_nodes = 22662
    cfg.hgd_roman_empire.manual_lr = 3.15e-6

    cfg.hgd_amazon_ratings.dataset_name = "HeterophilousGraphDataset_Amazon-ratings"
    cfg.hgd_amazon_ratings.format = "PyG"
    cfg.hgd_amazon_ratings.task = "node"
    cfg.hgd_amazon_ratings.task_type = "classification"
    cfg.hgd_amazon_ratings.loss_fun = "cross_entropy"
    cfg.hgd_amazon_ratings.task_dim = 5
    cfg.hgd_amazon_ratings.split_mode = "standard"
    cfg.hgd_amazon_ratings.transductive = True
    cfg.hgd_amazon_ratings.split_index = 0
    cfg.hgd_amazon_ratings.feat_dim = 300
    cfg.hgd_amazon_ratings.hidden_dim = 64
    cfg.hgd_amazon_ratings.activate_fn = "torch.nn.ReLU()"
    cfg.hgd_amazon_ratings.num_nodes = 24492
    cfg.hgd_amazon_ratings.graph_ratio_in_epoch = 0.8
    cfg.hgd_amazon_ratings.manual_lr = 3.5e-7

    cfg.hgd_minesweeper.dataset_name = "HeterophilousGraphDataset_Minesweeper"
    cfg.hgd_minesweeper.format = "PyG"
    cfg.hgd_minesweeper.task = "node"
    cfg.hgd_minesweeper.task_type = "classification"
    cfg.hgd_minesweeper.loss_fun = "cross_entropy"
    cfg.hgd_minesweeper.task_dim = 2
    cfg.hgd_minesweeper.split_mode = "standard"
    cfg.hgd_minesweeper.transductive = True
    cfg.hgd_minesweeper.split_index = 0
    cfg.hgd_minesweeper.feat_dim = 7
    cfg.hgd_minesweeper.hidden_dim = 64
    cfg.hgd_minesweeper.activate_fn = "torch.nn.ReLU()"
    cfg.hgd_minesweeper.num_nodes = 10000
    cfg.hgd_minesweeper.manual_lr = 3.73e-6

    cfg.hgd_tolokers.dataset_name = "HeterophilousGraphDataset_Tolokers"
    cfg.hgd_tolokers.format = "PyG"
    cfg.hgd_tolokers.task = "node"
    cfg.hgd_tolokers.task_type = "classification"
    cfg.hgd_tolokers.loss_fun = "cross_entropy"
    cfg.hgd_tolokers.task_dim = 2
    cfg.hgd_tolokers.split_mode = "standard"
    cfg.hgd_tolokers.transductive = True
    cfg.hgd_tolokers.split_index = 0
    cfg.hgd_tolokers.feat_dim = 10
    cfg.hgd_tolokers.hidden_dim = 64
    cfg.hgd_tolokers.activate_fn = "torch.nn.ReLU()"
    cfg.hgd_tolokers.num_nodes = 11758
    cfg.hgd_tolokers.manual_lr = 9.4e-7

    cfg.hgd_questions.dataset_name = "HeterophilousGraphDataset_Questions"
    cfg.hgd_questions.format = "PyG"
    cfg.hgd_questions.task = "node"
    cfg.hgd_questions.task_type = "classification"
    cfg.hgd_questions.loss_fun = "cross_entropy"
    cfg.hgd_questions.task_dim = 2
    cfg.hgd_questions.split_mode = "standard"
    cfg.hgd_questions.transductive = True
    cfg.hgd_questions.split_index = 0
    cfg.hgd_questions.feat_dim = 301
    cfg.hgd_questions.hidden_dim = 64
    cfg.hgd_questions.activate_fn = "torch.nn.ReLU()"
    cfg.hgd_questions.num_nodes = 48921
    cfg.hgd_questions.manual_lr = 2.59e-6

    cfg.twitch_de.dataset_name = "Twitch_DE"
    cfg.twitch_de.format = "PyG"
    cfg.twitch_de.task = "node"
    cfg.twitch_de.task_type = "classification"
    cfg.twitch_de.loss_fun = "cross_entropy"
    cfg.twitch_de.task_dim = 2
    cfg.twitch_de.split_mode = "random"
    cfg.twitch_de.transductive = True
    cfg.twitch_de.split_index = 0
    cfg.twitch_de.feat_dim = 128
    cfg.twitch_de.hidden_dim = 64
    cfg.twitch_de.activate_fn = "torch.nn.ReLU()"
    cfg.twitch_de.split = [0.6, 0.2, 0.2]
    cfg.twitch_de.num_nodes = 9498
    cfg.twitch_de.manual_lr = 9.7e-7

    cfg.twitch_en.dataset_name = "Twitch_EN"
    cfg.twitch_en.format = "PyG"
    cfg.twitch_en.task = "node"
    cfg.twitch_en.task_type = "classification"
    cfg.twitch_en.loss_fun = "cross_entropy"
    cfg.twitch_en.task_dim = 2
    cfg.twitch_en.split_mode = "random"
    cfg.twitch_en.transductive = True
    cfg.twitch_en.split_index = 0
    cfg.twitch_en.feat_dim = 128
    cfg.twitch_en.hidden_dim = 64
    cfg.twitch_en.activate_fn = "torch.nn.ReLU()"
    cfg.twitch_en.split = [0.6, 0.2, 0.2]
    cfg.twitch_en.num_nodes = 7126
    cfg.twitch_en.manual_lr = 4.3e-7

    cfg.twitch_es.dataset_name = "Twitch_ES"
    cfg.twitch_es.format = "PyG"
    cfg.twitch_es.task = "node"
    cfg.twitch_es.task_type = "classification"
    cfg.twitch_es.loss_fun = "cross_entropy"
    cfg.twitch_es.task_dim = 2
    cfg.twitch_es.split_mode = "random"
    cfg.twitch_es.transductive = True
    cfg.twitch_es.split_index = 0
    cfg.twitch_es.feat_dim = 128
    cfg.twitch_es.hidden_dim = 64
    cfg.twitch_es.activate_fn = "torch.nn.ReLU()"
    cfg.twitch_es.split = [0.6, 0.2, 0.2]
    cfg.twitch_es.num_nodes = 4648
    cfg.twitch_es.manual_lr = 4.6e-7

    cfg.twitch_fr.dataset_name = "Twitch_FR"
    cfg.twitch_fr.format = "PyG"
    cfg.twitch_fr.task = "node"
    cfg.twitch_fr.task_type = "classification"
    cfg.twitch_fr.loss_fun = "cross_entropy"
    cfg.twitch_fr.task_dim = 2
    cfg.twitch_fr.split_mode = "random"
    cfg.twitch_fr.transductive = True
    cfg.twitch_fr.split_index = 0
    cfg.twitch_fr.feat_dim = 128
    cfg.twitch_fr.hidden_dim = 64
    cfg.twitch_fr.activate_fn = "torch.nn.ReLU()"
    cfg.twitch_fr.split = [0.6, 0.2, 0.2]
    cfg.twitch_fr.num_nodes = 6551
    cfg.twitch_fr.manual_lr = 4.4e-7

    cfg.twitch_pt.dataset_name = "Twitch_PT"
    cfg.twitch_pt.format = "PyG"
    cfg.twitch_pt.task = "node"
    cfg.twitch_pt.task_type = "classification"
    cfg.twitch_pt.loss_fun = "cross_entropy"
    cfg.twitch_pt.task_dim = 2
    cfg.twitch_pt.split_mode = "random"
    cfg.twitch_pt.transductive = True
    cfg.twitch_pt.split_index = 0
    cfg.twitch_pt.feat_dim = 128
    cfg.twitch_pt.hidden_dim = 64
    cfg.twitch_pt.activate_fn = "torch.nn.ReLU()"
    cfg.twitch_pt.split = [0.6, 0.2, 0.2]
    cfg.twitch_pt.num_nodes = 1912
    cfg.twitch_pt.manual_lr = 5.2e-7

    cfg.twitch_ru.dataset_name = "Twitch_RU"
    cfg.twitch_ru.format = "PyG"
    cfg.twitch_ru.task = "node"
    cfg.twitch_ru.task_type = "classification"
    cfg.twitch_ru.loss_fun = "cross_entropy"
    cfg.twitch_ru.task_dim = 2
    cfg.twitch_ru.split_mode = "random"
    cfg.twitch_ru.transductive = True
    cfg.twitch_ru.split_index = 0
    cfg.twitch_ru.feat_dim = 128
    cfg.twitch_ru.hidden_dim = 64
    cfg.twitch_ru.activate_fn = "torch.nn.ReLU()"
    cfg.twitch_ru.split = [0.6, 0.2, 0.2]
    cfg.twitch_ru.num_nodes = 4385
    cfg.twitch_ru.manual_lr = 4.6e-7

    cfg.deezer_europe.dataset_name = "DeezerEurope"
    cfg.deezer_europe.format = "PyG"
    cfg.deezer_europe.task = "node"
    cfg.deezer_europe.task_type = "classification"
    cfg.deezer_europe.loss_fun = "cross_entropy"
    cfg.deezer_europe.task_dim = 2
    cfg.deezer_europe.split_mode = "random"
    cfg.deezer_europe.transductive = True
    cfg.deezer_europe.split_index = 0
    cfg.deezer_europe.feat_dim = 128
    cfg.deezer_europe.hidden_dim = 64
    cfg.deezer_europe.activate_fn = "torch.nn.ReLU()"
    cfg.deezer_europe.split = [0.6, 0.2, 0.2]
    cfg.deezer_europe.num_nodes = 28281
    cfg.deezer_europe.manual_lr = 2.99e-6

    cfg.github.dataset_name = "GitHub"
    cfg.github.format = "PyG"
    cfg.github.task = "node"
    cfg.github.task_type = "classification"
    cfg.github.loss_fun = "cross_entropy"
    cfg.github.task_dim = 2
    cfg.github.split_mode = "random"
    cfg.github.transductive = True
    cfg.github.split_index = 0
    cfg.github.feat_dim = 128
    cfg.github.hidden_dim = 64
    cfg.github.activate_fn = "torch.nn.ReLU()"
    cfg.github.split = [0.6, 0.2, 0.2]
    cfg.github.num_nodes = 37700
    cfg.github.manual_lr = 2.78e-6

    cfg.facebook_page_page.dataset_name = "FacebookPagePage"
    cfg.facebook_page_page.format = "PyG"
    cfg.facebook_page_page.task = "node"
    cfg.facebook_page_page.task_type = "classification"
    cfg.facebook_page_page.loss_fun = "cross_entropy"
    cfg.facebook_page_page.task_dim = 4
    cfg.facebook_page_page.split_mode = "random"
    cfg.facebook_page_page.transductive = True
    cfg.facebook_page_page.split_index = 0
    cfg.facebook_page_page.feat_dim = 128
    cfg.facebook_page_page.hidden_dim = 64
    cfg.facebook_page_page.activate_fn = "torch.nn.ReLU()"
    cfg.facebook_page_page.split = [0.6, 0.2, 0.2]
    cfg.facebook_page_page.num_nodes = 22470
    cfg.facebook_page_page.manual_lr = 3.6e-7

    cfg.last_fm_asia.dataset_name = "LastFMAsia"
    cfg.last_fm_asia.format = "PyG"
    cfg.last_fm_asia.task = "node"
    cfg.last_fm_asia.task_type = "classification"
    cfg.last_fm_asia.loss_fun = "cross_entropy"
    cfg.last_fm_asia.task_dim = 18
    cfg.last_fm_asia.split_mode = "random"
    cfg.last_fm_asia.transductive = True
    cfg.last_fm_asia.split_index = 0
    cfg.last_fm_asia.feat_dim = 128
    cfg.last_fm_asia.hidden_dim = 64
    cfg.last_fm_asia.activate_fn = "torch.nn.ReLU()"
    cfg.last_fm_asia.split = [0.6, 0.2, 0.2]
    cfg.last_fm_asia.num_nodes = 7624
    cfg.last_fm_asia.graph_ratio_in_epoch = 0.8
    cfg.last_fm_asia.manual_lr = 3.93e-6

    cfg.airports_usa.dataset_name = "Airports_USA"
    cfg.airports_usa.format = "PyG"
    cfg.airports_usa.task = "node"
    cfg.airports_usa.task_type = "classification"
    cfg.airports_usa.loss_fun = "cross_entropy"
    cfg.airports_usa.task_dim = 4
    cfg.airports_usa.split_mode = "random"
    cfg.airports_usa.transductive = True
    cfg.airports_usa.split_index = 0
    cfg.airports_usa.feat_dim = 1190
    cfg.airports_usa.hidden_dim = 128
    cfg.airports_usa.activate_fn = "torch.nn.ReLU()"
    cfg.airports_usa.split = [0.6, 0.2, 0.2]
    cfg.airports_usa.num_nodes = 1190
    cfg.airports_usa.manual_lr = 3.93e-6

    cfg.airports_brazil.dataset_name = "Airports_Brazil"
    cfg.airports_brazil.format = "PyG"
    cfg.airports_brazil.task = "node"
    cfg.airports_brazil.task_type = "classification"
    cfg.airports_brazil.loss_fun = "cross_entropy"
    cfg.airports_brazil.task_dim = 4
    cfg.airports_brazil.split_mode = "random"
    cfg.airports_brazil.transductive = True
    cfg.airports_brazil.split_index = 0
    cfg.airports_brazil.feat_dim = 131
    cfg.airports_brazil.hidden_dim = 64
    cfg.airports_brazil.activate_fn = "torch.nn.ReLU()"
    cfg.airports_brazil.split = [0.6, 0.2, 0.2]
    cfg.airports_brazil.num_nodes = 131
    cfg.airports_brazil.manual_lr = 5.5e-7

    cfg.airports_europe.dataset_name = "Airports_Europe"
    cfg.airports_europe.format = "PyG"
    cfg.airports_europe.task = "node"
    cfg.airports_europe.task_type = "classification"
    cfg.airports_europe.loss_fun = "cross_entropy"
    cfg.airports_europe.task_dim = 4
    cfg.airports_europe.split_mode = "random"
    cfg.airports_europe.transductive = True
    cfg.airports_europe.split_index = 0
    cfg.airports_europe.feat_dim = 399
    cfg.airports_europe.hidden_dim = 64
    cfg.airports_europe.activate_fn = "torch.nn.ReLU()"
    cfg.airports_europe.split = [0.6, 0.2, 0.2]
    cfg.airports_europe.num_nodes = 399
    cfg.airports_europe.manual_lr = 6.2e-7

    cfg.pol_blogs.dataset_name = "PolBlogs"
    cfg.pol_blogs.format = "PyG"
    cfg.pol_blogs.task = "node"
    cfg.pol_blogs.task_type = "classification"
    cfg.pol_blogs.loss_fun = "cross_entropy"
    cfg.pol_blogs.task_dim = 2
    cfg.pol_blogs.split_mode = "random"
    cfg.pol_blogs.transductive = True
    cfg.pol_blogs.split_index = 0
    cfg.pol_blogs.feat_dim = 1  # (has no features)
    cfg.pol_blogs.hidden_dim = 64
    cfg.pol_blogs.activate_fn = "torch.nn.ReLU()"
    cfg.pol_blogs.split = [0.6, 0.2, 0.2]
    cfg.pol_blogs.num_nodes = 1490
    cfg.pol_blogs.manual_lr = 5.7e-7

    cfg.email_eu_core.dataset_name = "EmailEUCore"
    cfg.email_eu_core.format = "PyG"
    cfg.email_eu_core.task = "node"
    cfg.email_eu_core.task_type = "classification"
    cfg.email_eu_core.loss_fun = "cross_entropy"
    cfg.email_eu_core.task_dim = 42
    cfg.email_eu_core.split_mode = "random"
    cfg.email_eu_core.transductive = True
    cfg.email_eu_core.split_index = 0
    cfg.email_eu_core.feat_dim = 1  # (has no features)
    cfg.email_eu_core.hidden_dim = 64
    cfg.email_eu_core.activate_fn = "torch.nn.ReLU()"
    cfg.email_eu_core.split = [0.6, 0.2, 0.2]
    cfg.email_eu_core.num_nodes = 1005
    cfg.email_eu_core.manual_lr = 1.36e-6

    cfg.lxd_penn94.dataset_name = "LINKXDataset_penn94"
    cfg.lxd_penn94.format = "PyG"
    cfg.lxd_penn94.task = "node"
    cfg.lxd_penn94.task_type = "classification"
    cfg.lxd_penn94.loss_fun = "cross_entropy"
    cfg.lxd_penn94.task_dim = 2
    cfg.lxd_penn94.split_mode = "standard"
    cfg.lxd_penn94.transductive = True
    cfg.lxd_penn94.split_index = 0
    cfg.lxd_penn94.feat_dim = 4814
    cfg.lxd_penn94.hidden_dim = 64
    cfg.lxd_penn94.activate_fn = "torch.nn.ReLU()"
    cfg.lxd_penn94.num_nodes = 41554
    cfg.lxd_penn94.manual_lr = 2.71e-6

    cfg.lxd_reed98.dataset_name = "LINKXDataset_reed98"
    cfg.lxd_reed98.format = "PyG"
    cfg.lxd_reed98.task = "node"
    cfg.lxd_reed98.task_type = "classification"
    cfg.lxd_reed98.loss_fun = "cross_entropy"
    cfg.lxd_reed98.task_dim = 2
    cfg.lxd_reed98.split_mode = "random"
    cfg.lxd_reed98.transductive = True
    cfg.lxd_reed98.split_index = 0
    cfg.lxd_reed98.feat_dim = 745
    cfg.lxd_reed98.hidden_dim = 64
    cfg.lxd_reed98.activate_fn = "torch.nn.ReLU()"
    cfg.lxd_reed98.split = [0.6, 0.2, 0.2]
    cfg.lxd_reed98.manual_lr = 1.37e-6

    cfg.lxd_amherst41.dataset_name = "LINKXDataset_amherst41"
    cfg.lxd_amherst41.format = "PyG"
    cfg.lxd_amherst41.task = "node"
    cfg.lxd_amherst41.task_type = "classification"
    cfg.lxd_amherst41.loss_fun = "cross_entropy"
    cfg.lxd_amherst41.task_dim = 2
    cfg.lxd_amherst41.split_mode = "random"
    cfg.lxd_amherst41.transductive = True
    cfg.lxd_amherst41.split_index = 0
    cfg.lxd_amherst41.feat_dim = 1193
    cfg.lxd_amherst41.hidden_dim = 128
    cfg.lxd_amherst41.activate_fn = "torch.nn.ReLU()"
    cfg.lxd_amherst41.split = [0.6, 0.2, 0.2]
    cfg.lxd_amherst41.manual_lr = 4.81e-6

    cfg.lxd_cornell5.dataset_name = "LINKXDataset_cornell5"
    cfg.lxd_cornell5.format = "PyG"
    cfg.lxd_cornell5.task = "node"
    cfg.lxd_cornell5.task_type = "classification"
    cfg.lxd_cornell5.loss_fun = "cross_entropy"
    cfg.lxd_cornell5.task_dim = 2
    cfg.lxd_cornell5.split_mode = "random"
    cfg.lxd_cornell5.transductive = True
    cfg.lxd_cornell5.split_index = 0
    cfg.lxd_cornell5.feat_dim = 4735
    cfg.lxd_cornell5.hidden_dim = 64
    cfg.lxd_cornell5.activate_fn = "torch.nn.ReLU()"
    cfg.lxd_cornell5.split = [0.6, 0.2, 0.2]
    cfg.lxd_cornell5.graph_ratio_in_epoch = 0.8
    cfg.lxd_cornell5.manual_lr = 3.7e-7

    cfg.lxd_johnshopkins55.dataset_name = "LINKXDataset_johnshopkins55"
    cfg.lxd_johnshopkins55.format = "PyG"
    cfg.lxd_johnshopkins55.task = "node"
    cfg.lxd_johnshopkins55.task_type = "classification"
    cfg.lxd_johnshopkins55.loss_fun = "cross_entropy"
    cfg.lxd_johnshopkins55.task_dim = 2
    cfg.lxd_johnshopkins55.split_mode = "random"
    cfg.lxd_johnshopkins55.transductive = True
    cfg.lxd_johnshopkins55.split_index = 0
    cfg.lxd_johnshopkins55.feat_dim = 2406
    cfg.lxd_johnshopkins55.hidden_dim = 128
    cfg.lxd_johnshopkins55.activate_fn = "torch.nn.ReLU()"
    cfg.lxd_johnshopkins55.split = [0.6, 0.2, 0.2]
    cfg.lxd_johnshopkins55.manual_lr = 1.08e-6

    cfg.lxd_genius.dataset_name = "LINKXDataset_genius"
    cfg.lxd_genius.format = "PyG"
    cfg.lxd_genius.task = "node"
    cfg.lxd_genius.task_type = "classification"
    cfg.lxd_genius.loss_fun = "cross_entropy"
    cfg.lxd_genius.task_dim = 2
    cfg.lxd_genius.split_mode = "random"
    cfg.lxd_genius.transductive = True
    cfg.lxd_genius.split_index = 0
    cfg.lxd_genius.feat_dim = 12
    cfg.lxd_genius.hidden_dim = 32
    cfg.lxd_genius.activate_fn = "torch.nn.ReLU()"
    cfg.lxd_genius.split = [0.6, 0.2, 0.2]
    cfg.lxd_genius.num_nodes = 421961
    cfg.lxd_genius.graph_ratio_in_epoch = 0.8
    cfg.lxd_genius.manual_lr = 1.7e-7

    cfg.karate_club.dataset_name = "KarateClub"
    cfg.karate_club.format = "PyG"
    cfg.karate_club.task = "node"
    cfg.karate_club.task_type = "classification"
    cfg.karate_club.loss_fun = "cross_entropy"
    cfg.karate_club.task_dim = 4
    cfg.karate_club.split_mode = "random"
    cfg.karate_club.transductive = True
    cfg.karate_club.split_index = 0
    cfg.karate_club.feat_dim = 34  # (one hot)
    cfg.karate_club.hidden_dim = 64
    cfg.karate_club.activate_fn = "torch.nn.ReLU()"
    cfg.karate_club.split = [0.6, 0.2, 0.2]

    cfg.planetoid_cora.dataset_name = "Planetoid_Cora"
    cfg.planetoid_cora.format = "PyG"
    cfg.planetoid_cora.task = "node"
    cfg.planetoid_cora.task_type = "classification"
    cfg.planetoid_cora.loss_fun = "cross_entropy"
    cfg.planetoid_cora.task_dim = 7
    cfg.planetoid_cora.split_mode = "standard"
    cfg.planetoid_cora.transductive = True
    cfg.planetoid_cora.split_index = 0
    cfg.planetoid_cora.feat_dim = 1433
    cfg.planetoid_cora.hidden_dim = 128
    cfg.planetoid_cora.activate_fn = "torch.nn.ReLU()"

    cfg.planetoid_citeseer.dataset_name = "Planetoid_CiteSeer"
    cfg.planetoid_citeseer.format = "PyG"
    cfg.planetoid_citeseer.task = "node"
    cfg.planetoid_citeseer.task_type = "classification"
    cfg.planetoid_citeseer.loss_fun = "cross_entropy"
    cfg.planetoid_citeseer.task_dim = 6
    cfg.planetoid_citeseer.split_mode = "standard"
    cfg.planetoid_citeseer.transductive = True
    cfg.planetoid_citeseer.split_index = 0
    cfg.planetoid_citeseer.feat_dim = 3703
    cfg.planetoid_citeseer.hidden_dim = 128
    cfg.planetoid_citeseer.activate_fn = "torch.nn.ReLU()"

    cfg.planetoid_pubmed.dataset_name = "Planetoid_PubMed"
    cfg.planetoid_pubmed.format = "PyG"
    cfg.planetoid_pubmed.task = "node"
    cfg.planetoid_pubmed.task_type = "classification"
    cfg.planetoid_pubmed.loss_fun = "cross_entropy"
    cfg.planetoid_pubmed.task_dim = 6
    cfg.planetoid_pubmed.split_mode = "standard"
    cfg.planetoid_pubmed.transductive = True
    cfg.planetoid_pubmed.split_index = 0
    cfg.planetoid_pubmed.feat_dim = 3703
    cfg.planetoid_pubmed.hidden_dim = 128
    cfg.planetoid_pubmed.activate_fn = "torch.nn.ReLU()"

    cfg.nell.dataset_name = "NELL"
    cfg.nell.format = "PyG"
    cfg.nell.task = "node"
    cfg.nell.task_type = "classification"
    cfg.nell.loss_fun = "cross_entropy"
    cfg.nell.task_dim = 186
    cfg.nell.split_mode = "standard"
    cfg.nell.transductive = True
    cfg.nell.split_index = 0
    cfg.nell.feat_dim = 61278
    cfg.nell.hidden_dim = 128
    cfg.nell.activate_fn = "torch.nn.ReLU()"
    cfg.nell.num_nodes = 65755

    cfg.citationfull_cora.dataset_name = "CitationFull_Cora"
    cfg.citationfull_cora.format = "PyG"
    cfg.citationfull_cora.task = "node"
    cfg.citationfull_cora.task_type = "classification"
    cfg.citationfull_cora.loss_fun = "cross_entropy"
    cfg.citationfull_cora.task_dim = 70
    cfg.citationfull_cora.split_mode = "random"
    cfg.citationfull_cora.transductive = True
    cfg.citationfull_cora.split_index = 0
    cfg.citationfull_cora.feat_dim = 8710
    cfg.citationfull_cora.hidden_dim = 128
    cfg.citationfull_cora.activate_fn = "torch.nn.ReLU()"
    cfg.citationfull_cora.split = [0.6, 0.2, 0.2]

    cfg.citationfull_cora_ml.dataset_name = "CitationFull_Cora_ML"
    cfg.citationfull_cora_ml.format = "PyG"
    cfg.citationfull_cora_ml.task = "node"
    cfg.citationfull_cora_ml.task_type = "classification"
    cfg.citationfull_cora_ml.loss_fun = "cross_entropy"
    cfg.citationfull_cora_ml.task_dim = 7
    cfg.citationfull_cora_ml.split_mode = "random"
    cfg.citationfull_cora_ml.transductive = True
    cfg.citationfull_cora_ml.split_index = 0
    cfg.citationfull_cora_ml.feat_dim = 2879
    cfg.citationfull_cora_ml.hidden_dim = 128
    cfg.citationfull_cora_ml.activate_fn = "torch.nn.ReLU()"
    cfg.citationfull_cora_ml.split = [0.6, 0.2, 0.2]
    cfg.citationfull_cora_ml.num_nodes = 2995
    cfg.citationfull_cora_ml.manual_lr = 1.18e-6

    cfg.citationfull_citeseer.dataset_name = "CitationFull_CiteSeer"
    cfg.citationfull_citeseer.format = "PyG"
    cfg.citationfull_citeseer.task = "node"
    cfg.citationfull_citeseer.task_type = "classification"
    cfg.citationfull_citeseer.loss_fun = "cross_entropy"
    cfg.citationfull_citeseer.task_dim = 6
    cfg.citationfull_citeseer.split_mode = "random"
    cfg.citationfull_citeseer.transductive = True
    cfg.citationfull_citeseer.split_index = 0
    cfg.citationfull_citeseer.feat_dim = 602
    cfg.citationfull_citeseer.hidden_dim = 64
    cfg.citationfull_citeseer.activate_fn = "torch.nn.ReLU()"
    cfg.citationfull_citeseer.split = [0.6, 0.2, 0.2]
    cfg.citationfull_citeseer.num_nodes = 4230
    cfg.citationfull_citeseer.graph_ratio_in_epoch = 0.8
    cfg.citationfull_citeseer.manual_lr = 4.7e-7

    cfg.citationfull_dblp.dataset_name = "CitationFull_DBLP"
    cfg.citationfull_dblp.format = "PyG"
    cfg.citationfull_dblp.task = "node"
    cfg.citationfull_dblp.task_type = "classification"
    cfg.citationfull_dblp.loss_fun = "cross_entropy"
    cfg.citationfull_dblp.task_dim = 4
    cfg.citationfull_dblp.split_mode = "random"
    cfg.citationfull_dblp.transductive = True
    cfg.citationfull_dblp.split_index = 0
    cfg.citationfull_dblp.feat_dim = 1639
    cfg.citationfull_dblp.hidden_dim = 128
    cfg.citationfull_dblp.activate_fn = "torch.nn.ReLU()"
    cfg.citationfull_dblp.split = [0.6, 0.2, 0.2]

    cfg.citationfull_pubmed.dataset_name = "CitationFull_PubMed"
    cfg.citationfull_pubmed.format = "PyG"
    cfg.citationfull_pubmed.task = "node"
    cfg.citationfull_pubmed.task_type = "classification"
    cfg.citationfull_pubmed.loss_fun = "cross_entropy"
    cfg.citationfull_pubmed.task_dim = 3
    cfg.citationfull_pubmed.split_mode = "random"
    cfg.citationfull_pubmed.transductive = True
    cfg.citationfull_pubmed.split_index = 0
    cfg.citationfull_pubmed.feat_dim = 500
    cfg.citationfull_pubmed.hidden_dim = 64
    cfg.citationfull_pubmed.activate_fn = "torch.nn.ReLU()"
    cfg.citationfull_pubmed.split = [0.6, 0.2, 0.2]
    cfg.citationfull_pubmed.num_nodes = 19717
    cfg.citationfull_pubmed.manual_lr = 3.7e-7

    cfg.snap_patents.dataset_name = "Snap_patents"
    cfg.snap_patents.format = "Snap_patents"
    cfg.snap_patents.task = "node"
    cfg.snap_patents.task_type = "classification"
    cfg.snap_patents.loss_fun = "cross_entropy"
    cfg.snap_patents.task_dim = 3
    cfg.snap_patents.split_mode = "random"
    cfg.snap_patents.transductive = True
    cfg.snap_patents.split_index = 0
    cfg.snap_patents.feat_dim = 500
    cfg.snap_patents.hidden_dim = 64
    cfg.snap_patents.activate_fn = "torch.nn.ReLU()"
    cfg.snap_patents.split = [0.6, 0.2, 0.2]
    cfg.snap_patents.num_nodes = 19717

    cfg.snap_pokec.dataset_name = "SnapDataset_soc-pokec"
    cfg.snap_pokec.format = "Snap_pokec"
    cfg.snap_pokec.task = "node"
    cfg.snap_pokec.task_type = "classification"
    cfg.snap_pokec.loss_fun = "cross_entropy"
    cfg.snap_pokec.task_dim = 2
    cfg.snap_pokec.split_mode = "random"
    cfg.snap_pokec.transductive = True
    cfg.snap_pokec.split_index = 0
    cfg.snap_pokec.feat_dim = 65
    cfg.snap_pokec.hidden_dim = 64
    cfg.snap_pokec.activate_fn = "torch.nn.ReLU()"
    cfg.snap_pokec.split = [0.6, 0.2, 0.2]
    cfg.snap_pokec.num_nodes = 1632804
    cfg.snap_pokec.graph_ratio_in_epoch = 0.4
    cfg.snap_pokec.manual_lr = 8e-8

    cfg.nr_aids.dataset_name = "AIDS"
    cfg.nr_aids.format = "Network_repository"
    cfg.nr_aids.task = "node"
    cfg.nr_aids.task_type = "classification"
    cfg.nr_aids.loss_fun = "cross_entropy"
    cfg.nr_aids.task_dim = 38
    cfg.nr_aids.split_mode = "random"
    cfg.nr_aids.transductive = True
    cfg.nr_aids.split_index = 0
    cfg.nr_aids.feat_dim = 4
    cfg.nr_aids.hidden_dim = 32
    cfg.nr_aids.activate_fn = "torch.nn.ReLU()"
    cfg.nr_aids.split = [0.6, 0.2, 0.2]
    cfg.nr_aids.num_nodes = 31385

    cfg.nr_ba_1_10_60_l5.dataset_name = "BA-1_10_60-L5"
    cfg.nr_ba_1_10_60_l5.format = "Network_repository"
    cfg.nr_ba_1_10_60_l5.task = "node"
    cfg.nr_ba_1_10_60_l5.task_type = "classification"
    cfg.nr_ba_1_10_60_l5.loss_fun = "cross_entropy"
    cfg.nr_ba_1_10_60_l5.task_dim = 5
    cfg.nr_ba_1_10_60_l5.split_mode = "random"
    cfg.nr_ba_1_10_60_l5.transductive = True
    cfg.nr_ba_1_10_60_l5.split_index = 0
    cfg.nr_ba_1_10_60_l5.feat_dim = 1
    cfg.nr_ba_1_10_60_l5.hidden_dim = 32
    cfg.nr_ba_1_10_60_l5.activate_fn = "torch.nn.ReLU()"
    cfg.nr_ba_1_10_60_l5.split = [0.6, 0.2, 0.2]
    cfg.nr_ba_1_10_60_l5.num_nodes = 804
    cfg.nr_ba_1_10_60_l5.manual_lr = 5.8e-7

    cfg.nr_ba_2_24_60_l2.dataset_name = "BA-2_24_60-L2"
    cfg.nr_ba_2_24_60_l2.format = "Network_repository"
    cfg.nr_ba_2_24_60_l2.task = "node"
    cfg.nr_ba_2_24_60_l2.task_type = "classification"
    cfg.nr_ba_2_24_60_l2.loss_fun = "cross_entropy"
    cfg.nr_ba_2_24_60_l2.task_dim = 2
    cfg.nr_ba_2_24_60_l2.split_mode = "random"
    cfg.nr_ba_2_24_60_l2.transductive = True
    cfg.nr_ba_2_24_60_l2.split_index = 0
    cfg.nr_ba_2_24_60_l2.feat_dim = 1
    cfg.nr_ba_2_24_60_l2.hidden_dim = 32
    cfg.nr_ba_2_24_60_l2.activate_fn = "torch.nn.ReLU()"
    cfg.nr_ba_2_24_60_l2.split = [0.6, 0.2, 0.2]
    cfg.nr_ba_2_24_60_l2.num_nodes = 10693
    cfg.nr_ba_2_24_60_l2.manual_lr = 3.68e-6

    cfg.nr_bzr.dataset_name = "BZR"
    cfg.nr_bzr.format = "Network_repository"
    cfg.nr_bzr.task = "node"
    cfg.nr_bzr.task_type = "classification"
    cfg.nr_bzr.loss_fun = "cross_entropy"
    cfg.nr_bzr.task_dim = 53
    cfg.nr_bzr.split_mode = "random"
    cfg.nr_bzr.transductive = True
    cfg.nr_bzr.split_index = 0
    cfg.nr_bzr.feat_dim = 3
    cfg.nr_bzr.hidden_dim = 32
    cfg.nr_bzr.activate_fn = "torch.nn.ReLU()"
    cfg.nr_bzr.split = [0.6, 0.2, 0.2]
    cfg.nr_bzr.num_nodes = 14479
    cfg.nr_bzr.manual_lr = 3.47e-6

    cfg.nr_cl_100k_1d8_l9.dataset_name = "CL-100K-1d8-L9"
    cfg.nr_cl_100k_1d8_l9.format = "Network_repository"
    cfg.nr_cl_100k_1d8_l9.task = "node"
    cfg.nr_cl_100k_1d8_l9.task_type = "classification"
    cfg.nr_cl_100k_1d8_l9.loss_fun = "cross_entropy"
    cfg.nr_cl_100k_1d8_l9.task_dim = 9
    cfg.nr_cl_100k_1d8_l9.split_mode = "random"
    cfg.nr_cl_100k_1d8_l9.transductive = True
    cfg.nr_cl_100k_1d8_l9.split_index = 0
    cfg.nr_cl_100k_1d8_l9.feat_dim = 1
    cfg.nr_cl_100k_1d8_l9.hidden_dim = 32
    cfg.nr_cl_100k_1d8_l9.activate_fn = "torch.nn.ReLU()"
    cfg.nr_cl_100k_1d8_l9.split = [0.6, 0.2, 0.2]
    cfg.nr_cl_100k_1d8_l9.num_nodes = 92482
    cfg.nr_cl_100k_1d8_l9.manual_lr = 2.7e-7

    cfg.nr_cl_10k_1d8_l5.dataset_name = "CL-10K-1d8-L5"
    cfg.nr_cl_10k_1d8_l5.format = "Network_repository"
    cfg.nr_cl_10k_1d8_l5.task = "node"
    cfg.nr_cl_10k_1d8_l5.task_type = "classification"
    cfg.nr_cl_10k_1d8_l5.loss_fun = "cross_entropy"
    cfg.nr_cl_10k_1d8_l5.task_dim = 5
    cfg.nr_cl_10k_1d8_l5.split_mode = "random"
    cfg.nr_cl_10k_1d8_l5.transductive = True
    cfg.nr_cl_10k_1d8_l5.split_index = 0
    cfg.nr_cl_10k_1d8_l5.feat_dim = 1
    cfg.nr_cl_10k_1d8_l5.hidden_dim = 32
    cfg.nr_cl_10k_1d8_l5.activate_fn = "torch.nn.ReLU()"
    cfg.nr_cl_10k_1d8_l5.split = [0.6, 0.2, 0.2]
    cfg.nr_cl_10k_1d8_l5.num_nodes = 10000
    cfg.nr_cl_10k_1d8_l5.graph_ratio_in_epoch = 0.8
    cfg.nr_cl_10k_1d8_l5.manual_lr = 4.1e-7

    cfg.nr_cl_10m_1d8_l5.dataset_name = "CL-10M-1d8-L5"
    cfg.nr_cl_10m_1d8_l5.format = "Network_repository"
    cfg.nr_cl_10m_1d8_l5.task = "node"
    cfg.nr_cl_10m_1d8_l5.task_type = "classification"
    cfg.nr_cl_10m_1d8_l5.loss_fun = "cross_entropy"
    cfg.nr_cl_10m_1d8_l5.task_dim = 5
    cfg.nr_cl_10m_1d8_l5.split_mode = "random"
    cfg.nr_cl_10m_1d8_l5.transductive = True
    cfg.nr_cl_10m_1d8_l5.split_index = 0
    cfg.nr_cl_10m_1d8_l5.feat_dim = 1
    cfg.nr_cl_10m_1d8_l5.hidden_dim = 32
    cfg.nr_cl_10m_1d8_l5.activate_fn = "torch.nn.ReLU()"
    cfg.nr_cl_10m_1d8_l5.split = [0.6, 0.2, 0.2]
    cfg.nr_cl_10m_1d8_l5.num_nodes = 10000000

    cfg.nr_cox2.dataset_name = "COX2"
    cfg.nr_cox2.format = "Network_repository"
    cfg.nr_cox2.task = "node"
    cfg.nr_cox2.task_type = "classification"
    cfg.nr_cox2.loss_fun = "cross_entropy"
    cfg.nr_cox2.task_dim = 35
    cfg.nr_cox2.split_mode = "random"
    cfg.nr_cox2.transductive = True
    cfg.nr_cox2.split_index = 0
    cfg.nr_cox2.feat_dim = 3
    cfg.nr_cox2.hidden_dim = 32
    cfg.nr_cox2.activate_fn = "torch.nn.ReLU()"
    cfg.nr_cox2.split = [0.6, 0.2, 0.2]
    cfg.nr_cox2.num_nodes = 19252

    cfg.nr_dblp_v1.dataset_name = "DBLP-v1"
    cfg.nr_dblp_v1.format = "Network_repository"
    cfg.nr_dblp_v1.task = "node"
    cfg.nr_dblp_v1.task_type = "classification"
    cfg.nr_dblp_v1.loss_fun = "cross_entropy"
    cfg.nr_dblp_v1.task_dim = 41324
    cfg.nr_dblp_v1.split_mode = "random"
    cfg.nr_dblp_v1.transductive = True
    cfg.nr_dblp_v1.split_index = 0
    cfg.nr_dblp_v1.feat_dim = 1
    cfg.nr_dblp_v1.hidden_dim = 32
    cfg.nr_dblp_v1.activate_fn = "torch.nn.ReLU()"
    cfg.nr_dblp_v1.split = [0.6, 0.2, 0.2]
    cfg.nr_dblp_v1.num_nodes = 203954

    cfg.nr_dd.dataset_name = "DD"
    cfg.nr_dd.format = "Network_repository"
    cfg.nr_dd.task = "node"
    cfg.nr_dd.task_type = "classification"
    cfg.nr_dd.loss_fun = "cross_entropy"
    cfg.nr_dd.task_dim = 89
    cfg.nr_dd.split_mode = "random"
    cfg.nr_dd.transductive = True
    cfg.nr_dd.split_index = 0
    cfg.nr_dd.feat_dim = 1
    cfg.nr_dd.hidden_dim = 32
    cfg.nr_dd.activate_fn = "torch.nn.ReLU()"
    cfg.nr_dd.split = [0.6, 0.2, 0.2]
    cfg.nr_dd.num_nodes = 334925
    cfg.nr_dd.manual_lr = 3.6e-7

    cfg.nr_dd199.dataset_name = "DD199"
    cfg.nr_dd199.format = "Network_repository"
    cfg.nr_dd199.task = "node"
    cfg.nr_dd199.task_type = "classification"
    cfg.nr_dd199.loss_fun = "cross_entropy"
    cfg.nr_dd199.task_dim = 20
    cfg.nr_dd199.split_mode = "random"
    cfg.nr_dd199.transductive = True
    cfg.nr_dd199.split_index = 0
    cfg.nr_dd199.feat_dim = 1
    cfg.nr_dd199.hidden_dim = 32
    cfg.nr_dd199.activate_fn = "torch.nn.ReLU()"
    cfg.nr_dd199.split = [0.6, 0.2, 0.2]
    cfg.nr_dd199.num_nodes = 841
    cfg.nr_dd199.manual_lr = 3.6e-7

    cfg.nr_dd21.dataset_name = "DD21"
    cfg.nr_dd21.format = "Network_repository"
    cfg.nr_dd21.task = "node"
    cfg.nr_dd21.task_type = "classification"
    cfg.nr_dd21.loss_fun = "cross_entropy"
    cfg.nr_dd21.task_dim = 40
    cfg.nr_dd21.split_mode = "random"
    cfg.nr_dd21.transductive = True
    cfg.nr_dd21.split_index = 0
    cfg.nr_dd21.feat_dim = 1
    cfg.nr_dd21.hidden_dim = 32
    cfg.nr_dd21.activate_fn = "torch.nn.ReLU()"
    cfg.nr_dd21.split = [0.6, 0.2, 0.2]
    cfg.nr_dd21.num_nodes = 5748
    cfg.nr_dd21.manual_lr = 3.6e-7

    cfg.nr_dd242.dataset_name = "DD242"
    cfg.nr_dd242.format = "Network_repository"
    cfg.nr_dd242.task = "node"
    cfg.nr_dd242.task_type = "classification"
    cfg.nr_dd242.loss_fun = "cross_entropy"
    cfg.nr_dd242.task_dim = 20
    cfg.nr_dd242.split_mode = "random"
    cfg.nr_dd242.transductive = True
    cfg.nr_dd242.split_index = 0
    cfg.nr_dd242.feat_dim = 1
    cfg.nr_dd242.hidden_dim = 32
    cfg.nr_dd242.activate_fn = "torch.nn.ReLU()"
    cfg.nr_dd242.split = [0.6, 0.2, 0.2]
    cfg.nr_dd242.num_nodes = 1284
    cfg.nr_dd242.manual_lr = 1.8e-7

    cfg.nr_dd244.dataset_name = "DD244"
    cfg.nr_dd244.format = "Network_repository"
    cfg.nr_dd244.task = "node"
    cfg.nr_dd244.task_type = "classification"
    cfg.nr_dd244.loss_fun = "cross_entropy"
    cfg.nr_dd244.task_dim = 20
    cfg.nr_dd244.split_mode = "random"
    cfg.nr_dd244.transductive = True
    cfg.nr_dd244.split_index = 0
    cfg.nr_dd244.feat_dim = 1
    cfg.nr_dd244.hidden_dim = 32
    cfg.nr_dd244.activate_fn = "torch.nn.ReLU()"
    cfg.nr_dd244.split = [0.6, 0.2, 0.2]
    cfg.nr_dd244.num_nodes = 291
    cfg.nr_dd244.manual_lr = 3.6e-7

    cfg.nr_dd349.dataset_name = "DD349"
    cfg.nr_dd349.format = "Network_repository"
    cfg.nr_dd349.task = "node"
    cfg.nr_dd349.task_type = "classification"
    cfg.nr_dd349.loss_fun = "cross_entropy"
    cfg.nr_dd349.task_dim = 20
    cfg.nr_dd349.split_mode = "random"
    cfg.nr_dd349.transductive = True
    cfg.nr_dd349.split_index = 0
    cfg.nr_dd349.feat_dim = 1
    cfg.nr_dd349.hidden_dim = 32
    cfg.nr_dd349.activate_fn = "torch.nn.ReLU()"
    cfg.nr_dd349.split = [0.6, 0.2, 0.2]
    cfg.nr_dd349.num_nodes = 897
    cfg.nr_dd349.manual_lr = 3.6e-7

    cfg.nr_dd497.dataset_name = "DD497"
    cfg.nr_dd497.format = "Network_repository"
    cfg.nr_dd497.task = "node"
    cfg.nr_dd497.task_type = "classification"
    cfg.nr_dd497.loss_fun = "cross_entropy"
    cfg.nr_dd497.task_dim = 20
    cfg.nr_dd497.split_mode = "random"
    cfg.nr_dd497.transductive = True
    cfg.nr_dd497.split_index = 0
    cfg.nr_dd497.feat_dim = 1
    cfg.nr_dd497.hidden_dim = 32
    cfg.nr_dd497.activate_fn = "torch.nn.ReLU()"
    cfg.nr_dd497.split = [0.6, 0.2, 0.2]
    cfg.nr_dd497.num_nodes = 903
    cfg.nr_dd497.manual_lr = 1.2e-6

    cfg.nr_dd6.dataset_name = "DD6"
    cfg.nr_dd6.format = "Network_repository"
    cfg.nr_dd6.task = "node"
    cfg.nr_dd6.task_type = "classification"
    cfg.nr_dd6.loss_fun = "cross_entropy"
    cfg.nr_dd6.task_dim = 20
    cfg.nr_dd6.split_mode = "random"
    cfg.nr_dd6.transductive = True
    cfg.nr_dd6.split_index = 0
    cfg.nr_dd6.feat_dim = 1
    cfg.nr_dd6.hidden_dim = 32
    cfg.nr_dd6.activate_fn = "torch.nn.ReLU()"
    cfg.nr_dd6.split = [0.6, 0.2, 0.2]
    cfg.nr_dd6.num_nodes = 4152
    cfg.nr_dd6.manual_lr = 3.6e-7

    cfg.nr_dd68.dataset_name = "DD68"
    cfg.nr_dd68.format = "Network_repository"
    cfg.nr_dd68.task = "node"
    cfg.nr_dd68.task_type = "classification"
    cfg.nr_dd68.loss_fun = "cross_entropy"
    cfg.nr_dd68.task_dim = 20
    cfg.nr_dd68.split_mode = "random"
    cfg.nr_dd68.transductive = True
    cfg.nr_dd68.split_index = 0
    cfg.nr_dd68.feat_dim = 1
    cfg.nr_dd68.hidden_dim = 32
    cfg.nr_dd68.activate_fn = "torch.nn.ReLU()"
    cfg.nr_dd68.split = [0.6, 0.2, 0.2]
    cfg.nr_dd68.num_nodes = 775
    cfg.nr_dd68.manual_lr = 1.2e-6

    cfg.nr_dd687.dataset_name = "DD687"
    cfg.nr_dd687.format = "Network_repository"
    cfg.nr_dd687.task = "node"
    cfg.nr_dd687.task_type = "classification"
    cfg.nr_dd687.loss_fun = "cross_entropy"
    cfg.nr_dd687.task_dim = 20
    cfg.nr_dd687.split_mode = "random"
    cfg.nr_dd687.transductive = True
    cfg.nr_dd687.split_index = 0
    cfg.nr_dd687.feat_dim = 1
    cfg.nr_dd687.hidden_dim = 32
    cfg.nr_dd687.activate_fn = "torch.nn.ReLU()"
    cfg.nr_dd687.split = [0.6, 0.2, 0.2]
    cfg.nr_dd687.num_nodes = 725
    cfg.nr_dd687.manual_lr = 1.2e-6

    cfg.nr_dhfr.dataset_name = "DHFR"
    cfg.nr_dhfr.format = "Network_repository"
    cfg.nr_dhfr.task = "node"
    cfg.nr_dhfr.task_type = "classification"
    cfg.nr_dhfr.loss_fun = "cross_entropy"
    cfg.nr_dhfr.task_dim = 53
    cfg.nr_dhfr.split_mode = "random"
    cfg.nr_dhfr.transductive = True
    cfg.nr_dhfr.split_index = 0
    cfg.nr_dhfr.feat_dim = 3
    cfg.nr_dhfr.hidden_dim = 32
    cfg.nr_dhfr.activate_fn = "torch.nn.ReLU()"
    cfg.nr_dhfr.split = [0.6, 0.2, 0.2]
    cfg.nr_dhfr.num_nodes = 32075
    cfg.nr_dhfr.manual_lr = 7.6e-7

    cfg.nr_enzymes.dataset_name = "ENZYMES"
    cfg.nr_enzymes.format = "Network_repository"
    cfg.nr_enzymes.task = "node"
    cfg.nr_enzymes.task_type = "classification"
    cfg.nr_enzymes.loss_fun = "cross_entropy"
    cfg.nr_enzymes.task_dim = 3
    cfg.nr_enzymes.split_mode = "random"
    cfg.nr_enzymes.transductive = True
    cfg.nr_enzymes.split_index = 0
    cfg.nr_enzymes.feat_dim = 18
    cfg.nr_enzymes.hidden_dim = 32
    cfg.nr_enzymes.activate_fn = "torch.nn.ReLU()"
    cfg.nr_enzymes.split = [0.6, 0.2, 0.2]
    cfg.nr_enzymes.num_nodes = 19580
    cfg.nr_enzymes.manual_lr = 8.5e-7

    cfg.nr_enzymes118.dataset_name = "ENZYMES118"
    cfg.nr_enzymes118.format = "Network_repository"
    cfg.nr_enzymes118.task = "node"
    cfg.nr_enzymes118.task_type = "classification"
    cfg.nr_enzymes118.loss_fun = "cross_entropy"
    cfg.nr_enzymes118.task_dim = 2
    cfg.nr_enzymes118.split_mode = "random"
    cfg.nr_enzymes118.transductive = True
    cfg.nr_enzymes118.split_index = 0
    cfg.nr_enzymes118.feat_dim = 1
    cfg.nr_enzymes118.hidden_dim = 32
    cfg.nr_enzymes118.activate_fn = "torch.nn.ReLU()"
    cfg.nr_enzymes118.split = [0.6, 0.2, 0.2]
    cfg.nr_enzymes118.num_nodes = 96
    cfg.nr_enzymes118.manual_lr = 3.7e-7

    cfg.nr_enzymes123.dataset_name = "ENZYMES123"
    cfg.nr_enzymes123.format = "Network_repository"
    cfg.nr_enzymes123.task = "node"
    cfg.nr_enzymes123.task_type = "classification"
    cfg.nr_enzymes123.loss_fun = "cross_entropy"
    cfg.nr_enzymes123.task_dim = 2
    cfg.nr_enzymes123.split_mode = "random"
    cfg.nr_enzymes123.transductive = True
    cfg.nr_enzymes123.split_index = 0
    cfg.nr_enzymes123.feat_dim = 1
    cfg.nr_enzymes123.hidden_dim = 32
    cfg.nr_enzymes123.activate_fn = "torch.nn.ReLU()"
    cfg.nr_enzymes123.split = [0.6, 0.2, 0.2]
    cfg.nr_enzymes123.num_nodes = 90
    cfg.nr_enzymes123.manual_lr = 3.25e-6

    cfg.nr_enzymes295.dataset_name = "ENZYMES295"
    cfg.nr_enzymes295.format = "Network_repository"
    cfg.nr_enzymes295.task = "node"
    cfg.nr_enzymes295.task_type = "classification"
    cfg.nr_enzymes295.loss_fun = "cross_entropy"
    cfg.nr_enzymes295.task_dim = 2
    cfg.nr_enzymes295.split_mode = "random"
    cfg.nr_enzymes295.transductive = True
    cfg.nr_enzymes295.split_index = 0
    cfg.nr_enzymes295.feat_dim = 1
    cfg.nr_enzymes295.hidden_dim = 32
    cfg.nr_enzymes295.activate_fn = "torch.nn.ReLU()"
    cfg.nr_enzymes295.split = [0.6, 0.2, 0.2]
    cfg.nr_enzymes295.num_nodes = 124
    cfg.nr_enzymes295.manual_lr = 3.25e-6

    cfg.nr_enzymes296.dataset_name = "ENZYMES296"
    cfg.nr_enzymes296.format = "Network_repository"
    cfg.nr_enzymes296.task = "node"
    cfg.nr_enzymes296.task_type = "classification"
    cfg.nr_enzymes296.loss_fun = "cross_entropy"
    cfg.nr_enzymes296.task_dim = 2
    cfg.nr_enzymes296.split_mode = "random"
    cfg.nr_enzymes296.transductive = True
    cfg.nr_enzymes296.split_index = 0
    cfg.nr_enzymes296.feat_dim = 1
    cfg.nr_enzymes296.hidden_dim = 32
    cfg.nr_enzymes296.activate_fn = "torch.nn.ReLU()"
    cfg.nr_enzymes296.split = [0.6, 0.2, 0.2]
    cfg.nr_enzymes296.num_nodes = 126
    cfg.nr_enzymes296.manual_lr = 3.7e-7

    cfg.nr_enzymes297.dataset_name = "ENZYMES297"
    cfg.nr_enzymes297.format = "Network_repository"
    cfg.nr_enzymes297.task = "node"
    cfg.nr_enzymes297.task_type = "classification"
    cfg.nr_enzymes297.loss_fun = "cross_entropy"
    cfg.nr_enzymes297.task_dim = 2
    cfg.nr_enzymes297.split_mode = "random"
    cfg.nr_enzymes297.transductive = True
    cfg.nr_enzymes297.split_index = 0
    cfg.nr_enzymes297.feat_dim = 1
    cfg.nr_enzymes297.hidden_dim = 32
    cfg.nr_enzymes297.activate_fn = "torch.nn.ReLU()"
    cfg.nr_enzymes297.split = [0.6, 0.2, 0.2]
    cfg.nr_enzymes297.num_nodes = 122
    cfg.nr_enzymes297.manual_lr = 8.5e-7

    cfg.nr_enzymes8.dataset_name = "ENZYMES8"
    cfg.nr_enzymes8.format = "Network_repository"
    cfg.nr_enzymes8.task = "node"
    cfg.nr_enzymes8.task_type = "classification"
    cfg.nr_enzymes8.loss_fun = "cross_entropy"
    cfg.nr_enzymes8.task_dim = 2
    cfg.nr_enzymes8.split_mode = "random"
    cfg.nr_enzymes8.transductive = True
    cfg.nr_enzymes8.split_index = 0
    cfg.nr_enzymes8.feat_dim = 1
    cfg.nr_enzymes8.hidden_dim = 32
    cfg.nr_enzymes8.activate_fn = "torch.nn.ReLU()"
    cfg.nr_enzymes8.split = [0.6, 0.2, 0.2]
    cfg.nr_enzymes8.num_nodes = 88
    cfg.nr_enzymes8.manual_lr = 3.25e-6

    cfg.nr_er_avgdeg10_100k_l2.dataset_name = "ER-AvgDeg10-100K-L2"
    cfg.nr_er_avgdeg10_100k_l2.format = "Network_repository"
    cfg.nr_er_avgdeg10_100k_l2.task = "node"
    cfg.nr_er_avgdeg10_100k_l2.task_type = "classification"
    cfg.nr_er_avgdeg10_100k_l2.loss_fun = "cross_entropy"
    cfg.nr_er_avgdeg10_100k_l2.task_dim = 2
    cfg.nr_er_avgdeg10_100k_l2.split_mode = "random"
    cfg.nr_er_avgdeg10_100k_l2.transductive = True
    cfg.nr_er_avgdeg10_100k_l2.split_index = 0
    cfg.nr_er_avgdeg10_100k_l2.feat_dim = 1
    cfg.nr_er_avgdeg10_100k_l2.hidden_dim = 32
    cfg.nr_er_avgdeg10_100k_l2.activate_fn = "torch.nn.ReLU()"
    cfg.nr_er_avgdeg10_100k_l2.split = [0.6, 0.2, 0.2]
    cfg.nr_er_avgdeg10_100k_l2.num_nodes = 99997
    cfg.nr_er_avgdeg10_100k_l2.manual_lr = 2.08e-6

    cfg.nr_er_avgdeg10_100k_l5.dataset_name = "ER-AvgDeg10-100K-L5"
    cfg.nr_er_avgdeg10_100k_l5.format = "Network_repository"
    cfg.nr_er_avgdeg10_100k_l5.task = "node"
    cfg.nr_er_avgdeg10_100k_l5.task_type = "classification"
    cfg.nr_er_avgdeg10_100k_l5.loss_fun = "cross_entropy"
    cfg.nr_er_avgdeg10_100k_l5.task_dim = 5
    cfg.nr_er_avgdeg10_100k_l5.split_mode = "random"
    cfg.nr_er_avgdeg10_100k_l5.transductive = True
    cfg.nr_er_avgdeg10_100k_l5.split_index = 0
    cfg.nr_er_avgdeg10_100k_l5.feat_dim = 1
    cfg.nr_er_avgdeg10_100k_l5.hidden_dim = 32
    cfg.nr_er_avgdeg10_100k_l5.activate_fn = "torch.nn.ReLU()"
    cfg.nr_er_avgdeg10_100k_l5.split = [0.6, 0.2, 0.2]
    cfg.nr_er_avgdeg10_100k_l5.num_nodes = 99997
    cfg.nr_er_avgdeg10_100k_l5.manual_lr = 5.7e-7

    cfg.nr_er_avgdeg10_1m_l2.dataset_name = "ER-AvgDeg10-1M-L2"
    cfg.nr_er_avgdeg10_1m_l2.format = "Network_repository"
    cfg.nr_er_avgdeg10_1m_l2.task = "node"
    cfg.nr_er_avgdeg10_1m_l2.task_type = "classification"
    cfg.nr_er_avgdeg10_1m_l2.loss_fun = "cross_entropy"
    cfg.nr_er_avgdeg10_1m_l2.task_dim = 2
    cfg.nr_er_avgdeg10_1m_l2.split_mode = "random"
    cfg.nr_er_avgdeg10_1m_l2.transductive = True
    cfg.nr_er_avgdeg10_1m_l2.split_index = 0
    cfg.nr_er_avgdeg10_1m_l2.feat_dim = 1
    cfg.nr_er_avgdeg10_1m_l2.hidden_dim = 32
    cfg.nr_er_avgdeg10_1m_l2.activate_fn = "torch.nn.ReLU()"
    cfg.nr_er_avgdeg10_1m_l2.split = [0.6, 0.2, 0.2]
    cfg.nr_er_avgdeg10_1m_l2.num_nodes = 999944

    cfg.nr_er_avgdeg10_1m_l5.dataset_name = "ER-AvgDeg10-1M-L5"
    cfg.nr_er_avgdeg10_1m_l5.format = "Network_repository"
    cfg.nr_er_avgdeg10_1m_l5.task = "node"
    cfg.nr_er_avgdeg10_1m_l5.task_type = "classification"
    cfg.nr_er_avgdeg10_1m_l5.loss_fun = "cross_entropy"
    cfg.nr_er_avgdeg10_1m_l5.task_dim = 5
    cfg.nr_er_avgdeg10_1m_l5.split_mode = "random"
    cfg.nr_er_avgdeg10_1m_l5.transductive = True
    cfg.nr_er_avgdeg10_1m_l5.split_index = 0
    cfg.nr_er_avgdeg10_1m_l5.feat_dim = 1
    cfg.nr_er_avgdeg10_1m_l5.hidden_dim = 32
    cfg.nr_er_avgdeg10_1m_l5.activate_fn = "torch.nn.ReLU()"
    cfg.nr_er_avgdeg10_1m_l5.split = [0.6, 0.2, 0.2]
    cfg.nr_er_avgdeg10_1m_l5.num_nodes = 999944

    cfg.nr_kki.dataset_name = "KKI"
    cfg.nr_kki.format = "Network_repository"
    cfg.nr_kki.task = "node"
    cfg.nr_kki.task_type = "classification"
    cfg.nr_kki.loss_fun = "cross_entropy"
    cfg.nr_kki.task_dim = 189
    cfg.nr_kki.split_mode = "random"
    cfg.nr_kki.transductive = True
    cfg.nr_kki.split_index = 0
    cfg.nr_kki.feat_dim = 1
    cfg.nr_kki.hidden_dim = 32
    cfg.nr_kki.activate_fn = "torch.nn.ReLU()"
    cfg.nr_kki.split = [0.6, 0.2, 0.2]
    cfg.nr_kki.num_nodes = 2238
    cfg.nr_kki.manual_lr = 5.1e-7

    cfg.nr_msrc_21.dataset_name = "MSRC-21"
    cfg.nr_msrc_21.format = "Network_repository"
    cfg.nr_msrc_21.task = "node"
    cfg.nr_msrc_21.task_type = "classification"
    cfg.nr_msrc_21.loss_fun = "cross_entropy"
    cfg.nr_msrc_21.task_dim = 24
    cfg.nr_msrc_21.split_mode = "random"
    cfg.nr_msrc_21.transductive = True
    cfg.nr_msrc_21.split_index = 0
    cfg.nr_msrc_21.feat_dim = 1
    cfg.nr_msrc_21.hidden_dim = 32
    cfg.nr_msrc_21.activate_fn = "torch.nn.ReLU()"
    cfg.nr_msrc_21.split = [0.6, 0.2, 0.2]
    cfg.nr_msrc_21.num_nodes = 43644
    cfg.nr_msrc_21.manual_lr = 2.68e-6

    cfg.nr_msrc_21c.dataset_name = "MSRC-21C"
    cfg.nr_msrc_21c.format = "Network_repository"
    cfg.nr_msrc_21c.task = "node"
    cfg.nr_msrc_21c.task_type = "classification"
    cfg.nr_msrc_21c.loss_fun = "cross_entropy"
    cfg.nr_msrc_21c.task_dim = 22
    cfg.nr_msrc_21c.split_mode = "random"
    cfg.nr_msrc_21c.transductive = True
    cfg.nr_msrc_21c.split_index = 0
    cfg.nr_msrc_21c.feat_dim = 1
    cfg.nr_msrc_21c.hidden_dim = 32
    cfg.nr_msrc_21c.activate_fn = "torch.nn.ReLU()"
    cfg.nr_msrc_21c.split = [0.6, 0.2, 0.2]
    cfg.nr_msrc_21c.num_nodes = 8418
    cfg.nr_msrc_21c.manual_lr = 7.1e-7

    cfg.nr_msrc_9.dataset_name = "MSRC-9"
    cfg.nr_msrc_9.format = "Network_repository"
    cfg.nr_msrc_9.task = "node"
    cfg.nr_msrc_9.task_type = "classification"
    cfg.nr_msrc_9.loss_fun = "cross_entropy"
    cfg.nr_msrc_9.task_dim = 10
    cfg.nr_msrc_9.split_mode = "random"
    cfg.nr_msrc_9.transductive = True
    cfg.nr_msrc_9.split_index = 0
    cfg.nr_msrc_9.feat_dim = 1
    cfg.nr_msrc_9.hidden_dim = 32
    cfg.nr_msrc_9.activate_fn = "torch.nn.ReLU()"
    cfg.nr_msrc_9.split = [0.6, 0.2, 0.2]
    cfg.nr_msrc_9.num_nodes = 8968
    cfg.nr_msrc_9.manual_lr = 3.81e-6

    cfg.nr_mutagenicity.dataset_name = "Mutagenicity"
    cfg.nr_mutagenicity.format = "Network_repository"
    cfg.nr_mutagenicity.task = "node"
    cfg.nr_mutagenicity.task_type = "classification"
    cfg.nr_mutagenicity.loss_fun = "cross_entropy"
    cfg.nr_mutagenicity.task_dim = 13
    cfg.nr_mutagenicity.split_mode = "random"
    cfg.nr_mutagenicity.transductive = True
    cfg.nr_mutagenicity.split_index = 0
    cfg.nr_mutagenicity.feat_dim = 1
    cfg.nr_mutagenicity.hidden_dim = 32
    cfg.nr_mutagenicity.activate_fn = "torch.nn.ReLU()"
    cfg.nr_mutagenicity.split = [0.6, 0.2, 0.2]
    cfg.nr_mutagenicity.num_nodes = 131488

    cfg.nr_nci1.dataset_name = "NCI1"
    cfg.nr_nci1.format = "Network_repository"
    cfg.nr_nci1.task = "node"
    cfg.nr_nci1.task_type = "classification"
    cfg.nr_nci1.loss_fun = "cross_entropy"
    cfg.nr_nci1.task_dim = 122750
    cfg.nr_nci1.split_mode = "random"
    cfg.nr_nci1.transductive = True
    cfg.nr_nci1.split_index = 0
    cfg.nr_nci1.feat_dim = 1
    cfg.nr_nci1.hidden_dim = 32
    cfg.nr_nci1.activate_fn = "torch.nn.ReLU()"
    cfg.nr_nci1.split = [0.6, 0.2, 0.2]
    cfg.nr_nci1.num_nodes = 122747

    cfg.nr_nci109.dataset_name = "NCI109"
    cfg.nr_nci109.format = "Network_repository"
    cfg.nr_nci109.task = "node"
    cfg.nr_nci109.task_type = "classification"
    cfg.nr_nci109.loss_fun = "cross_entropy"
    cfg.nr_nci109.task_dim = 38
    cfg.nr_nci109.split_mode = "random"
    cfg.nr_nci109.transductive = True
    cfg.nr_nci109.split_index = 0
    cfg.nr_nci109.feat_dim = 1
    cfg.nr_nci109.hidden_dim = 32
    cfg.nr_nci109.activate_fn = "torch.nn.ReLU()"
    cfg.nr_nci109.split = [0.6, 0.2, 0.2]
    cfg.nr_nci109.num_nodes = 122494

    cfg.nr_ohsu.dataset_name = "OHSU"
    cfg.nr_ohsu.format = "Network_repository"
    cfg.nr_ohsu.task = "node"
    cfg.nr_ohsu.task_type = "classification"
    cfg.nr_ohsu.loss_fun = "cross_entropy"
    cfg.nr_ohsu.task_dim = 189
    cfg.nr_ohsu.split_mode = "random"
    cfg.nr_ohsu.transductive = True
    cfg.nr_ohsu.split_index = 0
    cfg.nr_ohsu.feat_dim = 1
    cfg.nr_ohsu.hidden_dim = 32
    cfg.nr_ohsu.activate_fn = "torch.nn.ReLU()"
    cfg.nr_ohsu.split = [0.6, 0.2, 0.2]
    cfg.nr_ohsu.num_nodes = 6479
    cfg.nr_ohsu.manual_lr = 4.04e-6

    cfg.nr_plc_40_30_l5.dataset_name = "PLC-40-30-L5"
    cfg.nr_plc_40_30_l5.format = "Network_repository"
    cfg.nr_plc_40_30_l5.task = "node"
    cfg.nr_plc_40_30_l5.task_type = "classification"
    cfg.nr_plc_40_30_l5.loss_fun = "cross_entropy"
    cfg.nr_plc_40_30_l5.task_dim = 5
    cfg.nr_plc_40_30_l5.split_mode = "random"
    cfg.nr_plc_40_30_l5.transductive = True
    cfg.nr_plc_40_30_l5.split_index = 0
    cfg.nr_plc_40_30_l5.feat_dim = 1
    cfg.nr_plc_40_30_l5.hidden_dim = 32
    cfg.nr_plc_40_30_l5.activate_fn = "torch.nn.ReLU()"
    cfg.nr_plc_40_30_l5.split = [0.6, 0.2, 0.2]
    cfg.nr_plc_40_30_l5.num_nodes = 11025
    cfg.nr_plc_40_30_l5.manual_lr = 3.66e-6

    cfg.nr_plc_60_30_l2.dataset_name = "PLC-60-30-L2"
    cfg.nr_plc_60_30_l2.format = "Network_repository"
    cfg.nr_plc_60_30_l2.task = "node"
    cfg.nr_plc_60_30_l2.task_type = "classification"
    cfg.nr_plc_60_30_l2.loss_fun = "cross_entropy"
    cfg.nr_plc_60_30_l2.task_dim = 2
    cfg.nr_plc_60_30_l2.split_mode = "random"
    cfg.nr_plc_60_30_l2.transductive = True
    cfg.nr_plc_60_30_l2.split_index = 0
    cfg.nr_plc_60_30_l2.feat_dim = 1
    cfg.nr_plc_60_30_l2.hidden_dim = 32
    cfg.nr_plc_60_30_l2.activate_fn = "torch.nn.ReLU()"
    cfg.nr_plc_60_30_l2.split = [0.6, 0.2, 0.2]
    cfg.nr_plc_60_30_l2.num_nodes = 117572
    cfg.nr_plc_60_30_l2.manual_lr = 5.4e-7

    cfg.nr_proteins_full.dataset_name = "PROTEINS-full"
    cfg.nr_proteins_full.format = "Network_repository"
    cfg.nr_proteins_full.task = "node"
    cfg.nr_proteins_full.task_type = "classification"
    cfg.nr_proteins_full.loss_fun = "cross_entropy"
    cfg.nr_proteins_full.task_dim = 2
    cfg.nr_proteins_full.split_mode = "random"
    cfg.nr_proteins_full.transductive = True
    cfg.nr_proteins_full.split_index = 0
    cfg.nr_proteins_full.feat_dim = 29
    cfg.nr_proteins_full.hidden_dim = 32
    cfg.nr_proteins_full.activate_fn = "torch.nn.ReLU()"
    cfg.nr_proteins_full.split = [0.6, 0.2, 0.2]
    cfg.nr_proteins_full.num_nodes = 43471
    cfg.nr_proteins_full.manual_lr = 2.68e-6

    cfg.nr_ptc_fm.dataset_name = "PTC-FM"
    cfg.nr_ptc_fm.format = "Network_repository"
    cfg.nr_ptc_fm.task = "node"
    cfg.nr_ptc_fm.task_type = "classification"
    cfg.nr_ptc_fm.loss_fun = "cross_entropy"
    cfg.nr_ptc_fm.task_dim = 17
    cfg.nr_ptc_fm.split_mode = "random"
    cfg.nr_ptc_fm.transductive = True
    cfg.nr_ptc_fm.split_index = 0
    cfg.nr_ptc_fm.feat_dim = 1
    cfg.nr_ptc_fm.hidden_dim = 32
    cfg.nr_ptc_fm.activate_fn = "torch.nn.ReLU()"
    cfg.nr_ptc_fm.split = [0.6, 0.2, 0.2]
    cfg.nr_ptc_fm.num_nodes = 4925

    cfg.nr_ptc_fr.dataset_name = "PTC-FR"
    cfg.nr_ptc_fr.format = "Network_repository"
    cfg.nr_ptc_fr.task = "node"
    cfg.nr_ptc_fr.task_type = "classification"
    cfg.nr_ptc_fr.loss_fun = "cross_entropy"
    cfg.nr_ptc_fr.task_dim = 18
    cfg.nr_ptc_fr.split_mode = "random"
    cfg.nr_ptc_fr.transductive = True
    cfg.nr_ptc_fr.split_index = 0
    cfg.nr_ptc_fr.feat_dim = 1
    cfg.nr_ptc_fr.hidden_dim = 32
    cfg.nr_ptc_fr.activate_fn = "torch.nn.ReLU()"
    cfg.nr_ptc_fr.split = [0.6, 0.2, 0.2]
    cfg.nr_ptc_fr.num_nodes = 5110

    cfg.nr_ptc_mm.dataset_name = "PTC-MM"
    cfg.nr_ptc_mm.format = "Network_repository"
    cfg.nr_ptc_mm.task = "node"
    cfg.nr_ptc_mm.task_type = "classification"
    cfg.nr_ptc_mm.loss_fun = "cross_entropy"
    cfg.nr_ptc_mm.task_dim = 19
    cfg.nr_ptc_mm.split_mode = "random"
    cfg.nr_ptc_mm.transductive = True
    cfg.nr_ptc_mm.split_index = 0
    cfg.nr_ptc_mm.feat_dim = 1
    cfg.nr_ptc_mm.hidden_dim = 32
    cfg.nr_ptc_mm.activate_fn = "torch.nn.ReLU()"
    cfg.nr_ptc_mm.split = [0.6, 0.2, 0.2]
    cfg.nr_ptc_mm.num_nodes = 4695

    cfg.nr_ptc_mr.dataset_name = "PTC-MR"
    cfg.nr_ptc_mr.format = "Network_repository"
    cfg.nr_ptc_mr.task = "node"
    cfg.nr_ptc_mr.task_type = "classification"
    cfg.nr_ptc_mr.loss_fun = "cross_entropy"
    cfg.nr_ptc_mr.task_dim = 17
    cfg.nr_ptc_mr.split_mode = "random"
    cfg.nr_ptc_mr.transductive = True
    cfg.nr_ptc_mr.split_index = 0
    cfg.nr_ptc_mr.feat_dim = 1
    cfg.nr_ptc_mr.hidden_dim = 32
    cfg.nr_ptc_mr.activate_fn = "torch.nn.ReLU()"
    cfg.nr_ptc_mr.split = [0.6, 0.2, 0.2]
    cfg.nr_ptc_mr.num_nodes = 4915

    cfg.nr_peking_1.dataset_name = "Peking-1"
    cfg.nr_peking_1.format = "Network_repository"
    cfg.nr_peking_1.task = "node"
    cfg.nr_peking_1.task_type = "classification"
    cfg.nr_peking_1.loss_fun = "cross_entropy"
    cfg.nr_peking_1.task_dim = 189
    cfg.nr_peking_1.split_mode = "random"
    cfg.nr_peking_1.transductive = True
    cfg.nr_peking_1.split_index = 0
    cfg.nr_peking_1.feat_dim = 1
    cfg.nr_peking_1.hidden_dim = 32
    cfg.nr_peking_1.activate_fn = "torch.nn.ReLU()"
    cfg.nr_peking_1.split = [0.6, 0.2, 0.2]
    cfg.nr_peking_1.num_nodes = 3341
    cfg.nr_peking_1.manual_lr = 1.16e-6

    cfg.nr_pubmed.dataset_name = "PubMed"
    cfg.nr_pubmed.format = "Network_repository"
    cfg.nr_pubmed.task = "node"
    cfg.nr_pubmed.task_type = "classification"
    cfg.nr_pubmed.loss_fun = "cross_entropy"
    cfg.nr_pubmed.task_dim = 3
    cfg.nr_pubmed.split_mode = "random"
    cfg.nr_pubmed.transductive = True
    cfg.nr_pubmed.split_index = 0
    cfg.nr_pubmed.feat_dim = 1
    cfg.nr_pubmed.hidden_dim = 32
    cfg.nr_pubmed.activate_fn = "torch.nn.ReLU()"
    cfg.nr_pubmed.split = [0.6, 0.2, 0.2]
    cfg.nr_pubmed.num_nodes = 20061360

    cfg.nr_sw_10000_6_0d3_l2.dataset_name = "SW-10000-6-0d3-L2"
    cfg.nr_sw_10000_6_0d3_l2.format = "Network_repository"
    cfg.nr_sw_10000_6_0d3_l2.task = "node"
    cfg.nr_sw_10000_6_0d3_l2.task_type = "classification"
    cfg.nr_sw_10000_6_0d3_l2.loss_fun = "cross_entropy"
    cfg.nr_sw_10000_6_0d3_l2.task_dim = 2
    cfg.nr_sw_10000_6_0d3_l2.split_mode = "random"
    cfg.nr_sw_10000_6_0d3_l2.transductive = True
    cfg.nr_sw_10000_6_0d3_l2.split_index = 0
    cfg.nr_sw_10000_6_0d3_l2.feat_dim = 1
    cfg.nr_sw_10000_6_0d3_l2.hidden_dim = 32
    cfg.nr_sw_10000_6_0d3_l2.activate_fn = "torch.nn.ReLU()"
    cfg.nr_sw_10000_6_0d3_l2.split = [0.6, 0.2, 0.2]
    cfg.nr_sw_10000_6_0d3_l2.num_nodes = 10000
    cfg.nr_sw_10000_6_0d3_l2.manual_lr = 4.1e-7

    cfg.nr_sw_10000_6_0d3_l5.dataset_name = "SW-10000-6-0d3-L5"
    cfg.nr_sw_10000_6_0d3_l5.format = "Network_repository"
    cfg.nr_sw_10000_6_0d3_l5.task = "node"
    cfg.nr_sw_10000_6_0d3_l5.task_type = "classification"
    cfg.nr_sw_10000_6_0d3_l5.loss_fun = "cross_entropy"
    cfg.nr_sw_10000_6_0d3_l5.task_dim = 5
    cfg.nr_sw_10000_6_0d3_l5.split_mode = "random"
    cfg.nr_sw_10000_6_0d3_l5.transductive = True
    cfg.nr_sw_10000_6_0d3_l5.split_index = 0
    cfg.nr_sw_10000_6_0d3_l5.feat_dim = 1
    cfg.nr_sw_10000_6_0d3_l5.hidden_dim = 32
    cfg.nr_sw_10000_6_0d3_l5.activate_fn = "torch.nn.ReLU()"
    cfg.nr_sw_10000_6_0d3_l5.split = [0.6, 0.2, 0.2]
    cfg.nr_sw_10000_6_0d3_l5.num_nodes = 10000
    cfg.nr_sw_10000_6_0d3_l5.manual_lr = 3.73e-6

    cfg.nr_synthetic.dataset_name = "SYNTHETIC"
    cfg.nr_synthetic.format = "Network_repository"
    cfg.nr_synthetic.task = "node"
    cfg.nr_synthetic.task_type = "classification"
    cfg.nr_synthetic.loss_fun = "cross_entropy"
    cfg.nr_synthetic.task_dim = 8
    cfg.nr_synthetic.split_mode = "random"
    cfg.nr_synthetic.transductive = True
    cfg.nr_synthetic.split_index = 0
    cfg.nr_synthetic.feat_dim = 1
    cfg.nr_synthetic.hidden_dim = 32
    cfg.nr_synthetic.activate_fn = "torch.nn.ReLU()"
    cfg.nr_synthetic.split = [0.6, 0.2, 0.2]
    cfg.nr_synthetic.num_nodes = 30000
    cfg.nr_synthetic.manual_lr = 7.7e-7

    cfg.nr_terroristrel.dataset_name = "TerroristRel"
    cfg.nr_terroristrel.format = "Network_repository"
    cfg.nr_terroristrel.task = "node"
    cfg.nr_terroristrel.task_type = "classification"
    cfg.nr_terroristrel.loss_fun = "cross_entropy"
    cfg.nr_terroristrel.task_dim = 2
    cfg.nr_terroristrel.split_mode = "random"
    cfg.nr_terroristrel.transductive = True
    cfg.nr_terroristrel.split_index = 0
    cfg.nr_terroristrel.feat_dim = 1
    cfg.nr_terroristrel.hidden_dim = 32
    cfg.nr_terroristrel.activate_fn = "torch.nn.ReLU()"
    cfg.nr_terroristrel.split = [0.6, 0.2, 0.2]
    cfg.nr_terroristrel.num_nodes = 881
    cfg.nr_terroristrel.manual_lr = 1.39e-6

    cfg.nr_tox21_ahr.dataset_name = "Tox21-AHR"
    cfg.nr_tox21_ahr.format = "Network_repository"
    cfg.nr_tox21_ahr.task = "node"
    cfg.nr_tox21_ahr.task_type = "classification"
    cfg.nr_tox21_ahr.loss_fun = "cross_entropy"
    cfg.nr_tox21_ahr.task_dim = 48
    cfg.nr_tox21_ahr.split_mode = "random"
    cfg.nr_tox21_ahr.transductive = True
    cfg.nr_tox21_ahr.split_index = 0
    cfg.nr_tox21_ahr.feat_dim = 1
    cfg.nr_tox21_ahr.hidden_dim = 32
    cfg.nr_tox21_ahr.activate_fn = "torch.nn.ReLU()"
    cfg.nr_tox21_ahr.split = [0.6, 0.2, 0.2]
    cfg.nr_tox21_ahr.num_nodes = 147772

    cfg.nr_tox21_ar.dataset_name = "Tox21-AR"
    cfg.nr_tox21_ar.format = "Network_repository"
    cfg.nr_tox21_ar.task = "node"
    cfg.nr_tox21_ar.task_type = "classification"
    cfg.nr_tox21_ar.loss_fun = "cross_entropy"
    cfg.nr_tox21_ar.task_dim = 48
    cfg.nr_tox21_ar.split_mode = "random"
    cfg.nr_tox21_ar.transductive = True
    cfg.nr_tox21_ar.split_index = 0
    cfg.nr_tox21_ar.feat_dim = 1
    cfg.nr_tox21_ar.hidden_dim = 32
    cfg.nr_tox21_ar.activate_fn = "torch.nn.ReLU()"
    cfg.nr_tox21_ar.split = [0.6, 0.2, 0.2]
    cfg.nr_tox21_ar.num_nodes = 172175

    cfg.nr_tox21_ar_lbd.dataset_name = "Tox21-AR-LBD"
    cfg.nr_tox21_ar_lbd.format = "Network_repository"
    cfg.nr_tox21_ar_lbd.task = "node"
    cfg.nr_tox21_ar_lbd.task_type = "classification"
    cfg.nr_tox21_ar_lbd.loss_fun = "cross_entropy"
    cfg.nr_tox21_ar_lbd.task_dim = 47
    cfg.nr_tox21_ar_lbd.split_mode = "random"
    cfg.nr_tox21_ar_lbd.transductive = True
    cfg.nr_tox21_ar_lbd.split_index = 0
    cfg.nr_tox21_ar_lbd.feat_dim = 1
    cfg.nr_tox21_ar_lbd.hidden_dim = 32
    cfg.nr_tox21_ar_lbd.activate_fn = "torch.nn.ReLU()"
    cfg.nr_tox21_ar_lbd.split = [0.6, 0.2, 0.2]
    cfg.nr_tox21_ar_lbd.num_nodes = 152773

    cfg.nr_tox21_are.dataset_name = "Tox21-ARE"
    cfg.nr_tox21_are.format = "Network_repository"
    cfg.nr_tox21_are.task = "node"
    cfg.nr_tox21_are.task_type = "classification"
    cfg.nr_tox21_are.loss_fun = "cross_entropy"
    cfg.nr_tox21_are.task_dim = 45
    cfg.nr_tox21_are.split_mode = "random"
    cfg.nr_tox21_are.transductive = True
    cfg.nr_tox21_are.split_index = 0
    cfg.nr_tox21_are.feat_dim = 1
    cfg.nr_tox21_are.hidden_dim = 32
    cfg.nr_tox21_are.activate_fn = "torch.nn.ReLU()"
    cfg.nr_tox21_are.split = [0.6, 0.2, 0.2]
    cfg.nr_tox21_are.num_nodes = 116670

    cfg.nr_tox21_atad5.dataset_name = "Tox21-ATAD5"
    cfg.nr_tox21_atad5.format = "Network_repository"
    cfg.nr_tox21_atad5.task = "node"
    cfg.nr_tox21_atad5.task_type = "classification"
    cfg.nr_tox21_atad5.loss_fun = "cross_entropy"
    cfg.nr_tox21_atad5.task_dim = 162650
    cfg.nr_tox21_atad5.split_mode = "random"
    cfg.nr_tox21_atad5.transductive = True
    cfg.nr_tox21_atad5.split_index = 0
    cfg.nr_tox21_atad5.feat_dim = 1
    cfg.nr_tox21_atad5.hidden_dim = 32
    cfg.nr_tox21_atad5.activate_fn = "torch.nn.ReLU()"
    cfg.nr_tox21_atad5.split = [0.6, 0.2, 0.2]
    cfg.nr_tox21_atad5.num_nodes = 162647

    cfg.nr_tox21_er.dataset_name = "Tox21-ER"
    cfg.nr_tox21_er.format = "Network_repository"
    cfg.nr_tox21_er.task = "node"
    cfg.nr_tox21_er.task_type = "classification"
    cfg.nr_tox21_er.loss_fun = "cross_entropy"
    cfg.nr_tox21_er.task_dim = 47
    cfg.nr_tox21_er.split_mode = "random"
    cfg.nr_tox21_er.transductive = True
    cfg.nr_tox21_er.split_index = 0
    cfg.nr_tox21_er.feat_dim = 1
    cfg.nr_tox21_er.hidden_dim = 32
    cfg.nr_tox21_er.activate_fn = "torch.nn.ReLU()"
    cfg.nr_tox21_er.split = [0.6, 0.2, 0.2]
    cfg.nr_tox21_er.num_nodes = 135276

    cfg.nr_tox21_er_lbd.dataset_name = "Tox21-ER-LBD"
    cfg.nr_tox21_er_lbd.format = "Network_repository"
    cfg.nr_tox21_er_lbd.task = "node"
    cfg.nr_tox21_er_lbd.task_type = "classification"
    cfg.nr_tox21_er_lbd.loss_fun = "cross_entropy"
    cfg.nr_tox21_er_lbd.task_dim = 47
    cfg.nr_tox21_er_lbd.split_mode = "random"
    cfg.nr_tox21_er_lbd.transductive = True
    cfg.nr_tox21_er_lbd.split_index = 0
    cfg.nr_tox21_er_lbd.feat_dim = 1
    cfg.nr_tox21_er_lbd.hidden_dim = 32
    cfg.nr_tox21_er_lbd.activate_fn = "torch.nn.ReLU()"
    cfg.nr_tox21_er_lbd.split = [0.6, 0.2, 0.2]
    cfg.nr_tox21_er_lbd.num_nodes = 158058

    cfg.nr_tox21_hse.dataset_name = "Tox21-HSE"
    cfg.nr_tox21_hse.format = "Network_repository"
    cfg.nr_tox21_hse.task = "node"
    cfg.nr_tox21_hse.task_type = "classification"
    cfg.nr_tox21_hse.loss_fun = "cross_entropy"
    cfg.nr_tox21_hse.task_dim = 46
    cfg.nr_tox21_hse.split_mode = "random"
    cfg.nr_tox21_hse.transductive = True
    cfg.nr_tox21_hse.split_index = 0
    cfg.nr_tox21_hse.feat_dim = 1
    cfg.nr_tox21_hse.hidden_dim = 32
    cfg.nr_tox21_hse.activate_fn = "torch.nn.ReLU()"
    cfg.nr_tox21_hse.split = [0.6, 0.2, 0.2]
    cfg.nr_tox21_hse.num_nodes = 136239

    cfg.nr_tox21_mmp.dataset_name = "Tox21-MMP"
    cfg.nr_tox21_mmp.format = "Network_repository"
    cfg.nr_tox21_mmp.task = "node"
    cfg.nr_tox21_mmp.task_type = "classification"
    cfg.nr_tox21_mmp.loss_fun = "cross_entropy"
    cfg.nr_tox21_mmp.task_dim = 46
    cfg.nr_tox21_mmp.split_mode = "random"
    cfg.nr_tox21_mmp.transductive = True
    cfg.nr_tox21_mmp.split_index = 0
    cfg.nr_tox21_mmp.feat_dim = 1
    cfg.nr_tox21_mmp.hidden_dim = 32
    cfg.nr_tox21_mmp.activate_fn = "torch.nn.ReLU()"
    cfg.nr_tox21_mmp.split = [0.6, 0.2, 0.2]
    cfg.nr_tox21_mmp.num_nodes = 127998

    cfg.nr_tox21_ppar_gamma.dataset_name = "Tox21-PPAR-gamma"
    cfg.nr_tox21_ppar_gamma.format = "Network_repository"
    cfg.nr_tox21_ppar_gamma.task = "node"
    cfg.nr_tox21_ppar_gamma.task_type = "classification"
    cfg.nr_tox21_ppar_gamma.loss_fun = "cross_entropy"
    cfg.nr_tox21_ppar_gamma.task_dim = 45
    cfg.nr_tox21_ppar_gamma.split_mode = "random"
    cfg.nr_tox21_ppar_gamma.transductive = True
    cfg.nr_tox21_ppar_gamma.split_index = 0
    cfg.nr_tox21_ppar_gamma.feat_dim = 1
    cfg.nr_tox21_ppar_gamma.hidden_dim = 32
    cfg.nr_tox21_ppar_gamma.activate_fn = "torch.nn.ReLU()"
    cfg.nr_tox21_ppar_gamma.split = [0.6, 0.2, 0.2]
    cfg.nr_tox21_ppar_gamma.num_nodes = 140999

    cfg.nr_tox21_aromatase.dataset_name = "Tox21-aromatase"
    cfg.nr_tox21_aromatase.format = "Network_repository"
    cfg.nr_tox21_aromatase.task = "node"
    cfg.nr_tox21_aromatase.task_type = "classification"
    cfg.nr_tox21_aromatase.loss_fun = "cross_entropy"
    cfg.nr_tox21_aromatase.task_dim = 45
    cfg.nr_tox21_aromatase.split_mode = "random"
    cfg.nr_tox21_aromatase.transductive = True
    cfg.nr_tox21_aromatase.split_index = 0
    cfg.nr_tox21_aromatase.feat_dim = 1
    cfg.nr_tox21_aromatase.hidden_dim = 32
    cfg.nr_tox21_aromatase.activate_fn = "torch.nn.ReLU()"
    cfg.nr_tox21_aromatase.split = [0.6, 0.2, 0.2]
    cfg.nr_tox21_aromatase.num_nodes = 126483

    cfg.nr_tox21_p53.dataset_name = "Tox21_p53"
    cfg.nr_tox21_p53.format = "Network_repository"
    cfg.nr_tox21_p53.task = "node"
    cfg.nr_tox21_p53.task_type = "classification"
    cfg.nr_tox21_p53.loss_fun = "cross_entropy"
    cfg.nr_tox21_p53.task_dim = 46
    cfg.nr_tox21_p53.split_mode = "random"
    cfg.nr_tox21_p53.transductive = True
    cfg.nr_tox21_p53.split_index = 0
    cfg.nr_tox21_p53.feat_dim = 1
    cfg.nr_tox21_p53.hidden_dim = 32
    cfg.nr_tox21_p53.activate_fn = "torch.nn.ReLU()"
    cfg.nr_tox21_p53.split = [0.6, 0.2, 0.2]
    cfg.nr_tox21_p53.num_nodes = 153563
    cfg.nr_tox21_p53.graph_ratio_in_epoch = 0.8
    cfg.nr_tox21_p53.manual_lr = 2.3e-7

    cfg.nr_cora.dataset_name = "cora"
    cfg.nr_cora.format = "Network_repository"
    cfg.nr_cora.task = "node"
    cfg.nr_cora.task_type = "classification"
    cfg.nr_cora.loss_fun = "cross_entropy"
    cfg.nr_cora.task_dim = 7
    cfg.nr_cora.split_mode = "random"
    cfg.nr_cora.transductive = True
    cfg.nr_cora.split_index = 0
    cfg.nr_cora.feat_dim = 1
    cfg.nr_cora.hidden_dim = 32
    cfg.nr_cora.activate_fn = "torch.nn.ReLU()"
    cfg.nr_cora.split = [0.6, 0.2, 0.2]
    cfg.nr_cora.num_nodes = 2708

    cfg.nr_fb_cmu_carnegie49.dataset_name = "fb-CMU-Carnegie49"
    cfg.nr_fb_cmu_carnegie49.format = "Network_repository"
    cfg.nr_fb_cmu_carnegie49.task = "node"
    cfg.nr_fb_cmu_carnegie49.task_type = "classification"
    cfg.nr_fb_cmu_carnegie49.loss_fun = "cross_entropy"
    cfg.nr_fb_cmu_carnegie49.task_dim = 3
    cfg.nr_fb_cmu_carnegie49.split_mode = "random"
    cfg.nr_fb_cmu_carnegie49.transductive = True
    cfg.nr_fb_cmu_carnegie49.split_index = 0
    cfg.nr_fb_cmu_carnegie49.feat_dim = 1
    cfg.nr_fb_cmu_carnegie49.hidden_dim = 32
    cfg.nr_fb_cmu_carnegie49.activate_fn = "torch.nn.ReLU()"
    cfg.nr_fb_cmu_carnegie49.split = [0.6, 0.2, 0.2]
    cfg.nr_fb_cmu_carnegie49.num_nodes = 6637
    cfg.nr_fb_cmu_carnegie49.graph_ratio_in_epoch = 0.8
    cfg.nr_fb_cmu_carnegie49.manual_lr = 4.4e-7

    cfg.nr_gene.dataset_name = "gene"
    cfg.nr_gene.format = "Network_repository"
    cfg.nr_gene.task = "node"
    cfg.nr_gene.task_type = "classification"
    cfg.nr_gene.loss_fun = "cross_entropy"
    cfg.nr_gene.task_dim = 2
    cfg.nr_gene.split_mode = "random"
    cfg.nr_gene.transductive = True
    cfg.nr_gene.split_index = 0
    cfg.nr_gene.feat_dim = 1
    cfg.nr_gene.hidden_dim = 32
    cfg.nr_gene.activate_fn = "torch.nn.ReLU()"
    cfg.nr_gene.split = [0.6, 0.2, 0.2]
    cfg.nr_gene.num_nodes = 1103
    cfg.nr_gene.manual_lr = 5.3e-6

    cfg.nr_proteins_all.dataset_name = "proteins-all"
    cfg.nr_proteins_all.format = "Network_repository"
    cfg.nr_proteins_all.task = "node"
    cfg.nr_proteins_all.task_type = "classification"
    cfg.nr_proteins_all.loss_fun = "cross_entropy"
    cfg.nr_proteins_all.task_dim = 3
    cfg.nr_proteins_all.split_mode = "random"
    cfg.nr_proteins_all.transductive = True
    cfg.nr_proteins_all.split_index = 0
    cfg.nr_proteins_all.feat_dim = 1
    cfg.nr_proteins_all.hidden_dim = 32
    cfg.nr_proteins_all.activate_fn = "torch.nn.ReLU()"
    cfg.nr_proteins_all.split = [0.6, 0.2, 0.2]
    cfg.nr_proteins_all.num_nodes = 43471
    cfg.nr_proteins_all.manual_lr = 3.2e-7

    cfg.nr_reality_call.dataset_name = "reality-call"
    cfg.nr_reality_call.format = "Network_repository"
    cfg.nr_reality_call.task = "node"
    cfg.nr_reality_call.task_type = "classification"
    cfg.nr_reality_call.loss_fun = "cross_entropy"
    cfg.nr_reality_call.task_dim = 2
    cfg.nr_reality_call.split_mode = "random"
    cfg.nr_reality_call.transductive = True
    cfg.nr_reality_call.split_index = 0
    cfg.nr_reality_call.feat_dim = 1
    cfg.nr_reality_call.hidden_dim = 32
    cfg.nr_reality_call.activate_fn = "torch.nn.ReLU()"
    cfg.nr_reality_call.split = [0.6, 0.2, 0.2]
    cfg.nr_reality_call.num_nodes = 27058
    cfg.nr_reality_call.manual_lr = 3.02e-6

    cfg.nr_soc_blogcatalog_asu.dataset_name = "soc-BlogCatalog-ASU"
    cfg.nr_soc_blogcatalog_asu.format = "Network_repository"
    cfg.nr_soc_blogcatalog_asu.task = "node"
    cfg.nr_soc_blogcatalog_asu.task_type = "classification"
    cfg.nr_soc_blogcatalog_asu.loss_fun = "cross_entropy"
    cfg.nr_soc_blogcatalog_asu.task_dim = 39
    cfg.nr_soc_blogcatalog_asu.split_mode = "random"
    cfg.nr_soc_blogcatalog_asu.transductive = True
    cfg.nr_soc_blogcatalog_asu.split_index = 0
    cfg.nr_soc_blogcatalog_asu.feat_dim = 1
    cfg.nr_soc_blogcatalog_asu.hidden_dim = 32
    cfg.nr_soc_blogcatalog_asu.activate_fn = "torch.nn.ReLU()"
    cfg.nr_soc_blogcatalog_asu.split = [0.6, 0.2, 0.2]
    cfg.nr_soc_blogcatalog_asu.num_nodes = 10312

    cfg.nr_soc_flickr_asu.dataset_name = "soc-Flickr-ASU"
    cfg.nr_soc_flickr_asu.format = "Network_repository"
    cfg.nr_soc_flickr_asu.task = "node"
    cfg.nr_soc_flickr_asu.task_type = "classification"
    cfg.nr_soc_flickr_asu.loss_fun = "cross_entropy"
    cfg.nr_soc_flickr_asu.task_dim = 195
    cfg.nr_soc_flickr_asu.split_mode = "random"
    cfg.nr_soc_flickr_asu.transductive = True
    cfg.nr_soc_flickr_asu.split_index = 0
    cfg.nr_soc_flickr_asu.feat_dim = 1
    cfg.nr_soc_flickr_asu.hidden_dim = 32
    cfg.nr_soc_flickr_asu.activate_fn = "torch.nn.ReLU()"
    cfg.nr_soc_flickr_asu.split = [0.6, 0.2, 0.2]
    cfg.nr_soc_flickr_asu.num_nodes = 80513

    cfg.nr_soc_youtube_asu.dataset_name = "soc-YouTube-ASU"
    cfg.nr_soc_youtube_asu.format = "Network_repository"
    cfg.nr_soc_youtube_asu.task = "node"
    cfg.nr_soc_youtube_asu.task_type = "classification"
    cfg.nr_soc_youtube_asu.loss_fun = "cross_entropy"
    cfg.nr_soc_youtube_asu.task_dim = 47
    cfg.nr_soc_youtube_asu.split_mode = "random"
    cfg.nr_soc_youtube_asu.transductive = True
    cfg.nr_soc_youtube_asu.split_index = 0
    cfg.nr_soc_youtube_asu.feat_dim = 1
    cfg.nr_soc_youtube_asu.hidden_dim = 32
    cfg.nr_soc_youtube_asu.activate_fn = "torch.nn.ReLU()"
    cfg.nr_soc_youtube_asu.split = [0.6, 0.2, 0.2]
    cfg.nr_soc_youtube_asu.num_nodes = 644063

    cfg.nr_soc_political_retweet.dataset_name = "soc-political-retweet"
    cfg.nr_soc_political_retweet.format = "Network_repository"
    cfg.nr_soc_political_retweet.task = "node"
    cfg.nr_soc_political_retweet.task_type = "classification"
    cfg.nr_soc_political_retweet.loss_fun = "cross_entropy"
    cfg.nr_soc_political_retweet.task_dim = 2
    cfg.nr_soc_political_retweet.split_mode = "random"
    cfg.nr_soc_political_retweet.transductive = True
    cfg.nr_soc_political_retweet.split_index = 0
    cfg.nr_soc_political_retweet.feat_dim = 1
    cfg.nr_soc_political_retweet.hidden_dim = 32
    cfg.nr_soc_political_retweet.activate_fn = "torch.nn.ReLU()"
    cfg.nr_soc_political_retweet.split = [0.6, 0.2, 0.2]
    cfg.nr_soc_political_retweet.num_nodes = 18469

    cfg.nr_webkb_wisc.dataset_name = "webkb-wisc"
    cfg.nr_webkb_wisc.format = "Network_repository"
    cfg.nr_webkb_wisc.task = "node"
    cfg.nr_webkb_wisc.task_type = "classification"
    cfg.nr_webkb_wisc.loss_fun = "cross_entropy"
    cfg.nr_webkb_wisc.task_dim = 5
    cfg.nr_webkb_wisc.split_mode = "random"
    cfg.nr_webkb_wisc.transductive = True
    cfg.nr_webkb_wisc.split_index = 0
    cfg.nr_webkb_wisc.feat_dim = 1
    cfg.nr_webkb_wisc.hidden_dim = 32
    cfg.nr_webkb_wisc.activate_fn = "torch.nn.ReLU()"
    cfg.nr_webkb_wisc.split = [0.6, 0.2, 0.2]
    cfg.nr_webkb_wisc.num_nodes = 265
