from torch_geometric.graphgym.register import register_config
from yacs.config import CfgNode as CN


@register_config("posenc")
def set_cfg_posenc(cfg):
    """Extend configuration with positional encoding options."""

    # Argument group for each Positional Encoding class.
    cfg.posenc_SignNet = CN()

    # Common arguments to all PE types.
    for name in [
        "posenc_SignNet",
    ]:
        pecfg = getattr(cfg, name)

        # Use extended positional encodings
        pecfg.enable = False

        # Neural-net model type within the PE encoder:
        # 'DeepSet', 'Transformer', 'Linear', 'none', ...
        pecfg.model = "none"

        # Size of Positional Encoding embedding
        pecfg.dim_pos_emb = 16

        # Number of layers in PE encoder model
        pecfg.layers = 3

        # Number of attention heads in PE encoder when model == 'Transformer'
        pecfg.n_heads = 4

        # Number of layers to apply in LapPE encoder post its pooling stage
        pecfg.post_layers = 0

        # Choice of normalization applied to raw PE stats: 'none', 'BatchNorm'
        pecfg.raw_norm_type = "none"

        # In addition to appending PE to the node features, pass them also as
        # a separate variable in the PyG graph batch object.
        pecfg.pass_as_var = False

    # Config for Laplacian Eigen-decomposition for PEs that use it.
    for name in [
        "posenc_SignNet",
    ]:
        pecfg = getattr(cfg, name)
        pecfg.eigen = CN()

        # The normalization scheme for the graph Laplacian: 'none', 'sym', or 'rw'
        pecfg.eigen.laplacian_norm = "sym"

        # The normalization scheme for the eigen vectors of the Laplacian
        pecfg.eigen.eigvec_norm = "L2"

        # Maximum number of top smallest frequencies & eigenvectors to use
        pecfg.eigen.max_freqs = 10

    # Config for SignNet-specific options.
    cfg.posenc_SignNet.phi_out_dim = 4
    cfg.posenc_SignNet.phi_hidden_dim = 64
