
function [A,B,C,D,R,Q,GaA,GaB,GaC,GaD,mu,error]=MLE(Y,U,n,mm,p,T,Iter_Max,xi,rr)

% Y: mm*T
% U: p*T

% 
%% initial conditions

%mu(:,:,1)=0.1*ones(n,1); Sig(:,:,1)=0.1*eye(n); 

mu(:,:,1)=xi; 

if size(rr,1)==1
    Sig(:,:,1)=(rr^2)*eye(n);
else
    Sig(:,:,1)=rr*rr';
end

ts=1;

A=ts*eye(n); B=ts*eye(n,p); 
C=ts*eye(mm,n); D=ts*eye(mm,p); 

R=ts*eye(n);Q=ts*eye(mm);


p1=1e5;

GaA=p1*ones(n,n); GaB=p1*ones(n,p); GaC=p1*ones(mm,n); GaD=p1*ones(mm,p); 

a0=1e-5;b0=1e-5;

%% Iteration loop
error(:,1)=ones(6,1);threshold=1e-18;ncount=0; 
%error=1;threshold=1e-14;ncount=0; % thr: The threshold to stop the iteration  ncount: record the number of iteration

while  max(error(:,ncount+1))>threshold
    
    A2=A; % In order to compute || A^(k+1)-A^(k)||
    B2=B;C2=C;D2=D;R2=R;Q2=Q;
    
    ncount=ncount+1; %

    if ncount>Iter_Max
        break;
    end
        
    if mod(ncount,100)==0 
        fprintf('This is the %d-th iteration \n',ncount) 
    end

   %%  KF filter

   for i=1:T
       mubar(:,:,i)=A*mu(:,:,i)+B*U(:,i);
       Sigbar(:,:,i)=A*Sig(:,:,i)*A'+R;
       K(:,:,i)=Sigbar(:,:,i)*C'/(C*Sigbar(:,:,i)*C'+Q);
       mu(:,:,i+1)= mubar(:,:,i)+K(:,:,i)*(Y(:,i)-C*mubar(:,:,i)-D*U(:,i));
       Sig(:,:,i+1)=(eye(n)-K(:,:,i)*C)*Sigbar(:,:,i);
   end
   


  %%  Kalman smoother
  
  m(:,:,T+1)=mu(:,:,T+1);
  P(:,:,T+1)=Sig(:,:,T+1); 
   

   for i=1:T
       ii=T+1-i;
       G(:,:,ii)=Sig(:,:,ii)*A'/Sigbar(:,:,ii);  
       m(:,:,ii)=mu(:,:,ii)+G(:,:,ii)*(m(:,:,ii+1)-mubar(:,:,ii));% the mean of KS
       P(:,:,ii)=Sig(:,:,ii)+G(:,:,ii)*(P(:,:,ii+1)-Sigbar(:,:,ii))*G(:,:,ii)';% the variance of KS
   end
    
   m(:,:,1)=mu(:,:,1);
   P(:,:,1)=Sig(:,:,1);

 
   %% PC(:,:,i) is the covariance of X(i) and X(i-1)
   
   PC(:,:,T)=(eye(n)-K(:,:,T)*C)*A*Sig(:,:,T); % initial conditions
   
   for i=1:T-1
       ii=T-i;
       PC(:,:,ii)=Sig(:,:,ii+1)*G(:,:,ii)'+G(:,:,ii+1)*(PC(:,:,ii+1)-A*Sig(:,:,ii+1))*G(:,:,ii)';% 计算X(i)和X(i-1)之间的方差
   end

   
   %% update A

   MA1=zeros(n);MA2=zeros(n);

   for i=1:T
       MA1=MA1+(m(:,:,i+1)-B*U(:,i))*m(:,:,i)'+PC(:,:,i);
       MA2=MA2+P(:,:,i)+m(:,:,i)*m(:,:,i)';
       %MA=MA+(m(:,:,i+1)-A*m(:,:,i)-B*U(:,i))*m(:,:,i)'+PC(:,:,i)-A*P(:,:,i);
   end

   A=MA1/MA2;

   %A=GaA.*(R\eye(n)*MA)
    
   %% update B

   MB1=zeros(n,p);MB2=zeros(p);

   for i=1:T
       MB1=MB1+(m(:,:,i+1)-A*m(:,:,i))*U(:,i)';
       MB2=MB2+U(:,i)*U(:,i)';
      % MB=MB+(m(:,:,i+1)-A*m(:,:,i)-B*U(:,i))*U(:,i)';
   end

   B=MB1/MB2;

   %B=GaB.*(R\eye(n)*MB)

   %% update C

   MC1=zeros(mm,n);MC2=zeros(n);

   for i=1:T
       MC1=MC1+(Y(:,i)-D*U(:,i))*m(:,:,i+1)';
       MC2=MC2+P(:,:,i+1)+m(:,:,i+1)*m(:,:,i+1)';
       %MC=MC+(Y(:,i)-C*m(:,:,i+1)-D*U(:,i))*m(:,:,i)'-C*P(:,:,i+1);
   end
   C=MC1/MC2;

  % C=GaC.*(Q\eye(mm)*MC)

   %% update D

   MD1=zeros(mm,p);MD2=zeros(p);

   for i=1:T
       MD1=MD1+(Y(:,i)-C*m(:,:,i+1))*U(:,i)';
       MD2=MD2+U(:,i)*U(:,i)';
    %  MD=MD+(Y(:,i)-C*m(:,:,i+1)-D*U(:,i))*U(:,i)';
   end

   D=MD1/MD2;

   %D=GaD.*(Q\eye(mm)*MD)


   %% update R
   MR1=zeros(n);MR2=zeros(n);

   for i=1:T
       MR1=MR1+(m(:,:,i+1)-A*m(:,:,i)-B*U(:,i))*(m(:,:,i+1)-A*m(:,:,i)-B*U(:,i))';
       MR2=MR2+P(:,:,i+1)-A*PC(:,:,i)-PC(:,:,i)*A'+A*P(:,:,i)*A';
   end

  

  % R=MR1/T+MR2/T-(R*diag(diag((R\eye(n))*MR1*(R\eye(n))))*R)/(2*T)-(R*diag(diag((R\eye(n))*MR2*(R\eye(n))))*R)/(2*T)
  R=MR1/T+MR2/T;   %R=MR1/T-diag(diag(MR1))/(2*T)+MR2/T-diag(diag(MR2))/(2*T)+diag(diag(R\eye(n)))/2;
 

   %% update Q
   MQ1=zeros(mm);MQ2=zeros(mm);

   for i=1:T
       MQ1=MQ1+(Y(:,i)-C*m(:,:,i+1)-D*U(:,i))*(Y(:,i)-C*m(:,:,i+1)-D*U(:,i))';
       MQ2=MQ2+C*P(:,:,i+1)*C';
      % MQ1=(Q\eye(mm))*(Y(:,i)-C*m(:,:,i+1)-D*U(:,i))*(Y(:,i)-C*m(:,:,i+1)-D*U(:,i))'*(Q\eye(mm));
      % MQ2=(Q\eye(mm))*C*P(:,:,i)*C*(Q\eye(mm));
   end


    Q=MQ1/T+MQ2/T;

   %Q=MQ1/T-diag(diag(MQ1))/(2*T)+MQ2/(T+1)-diag(diag(MQ2))/(2*T)+diag(diag(Q\eye(mm)))/2;
  % Q=Q\eye(mm)

 

   
 

  
  %% update initial value of x_0

  % mu(:,:,1)=m(:,:,1); 
  % Sig(:,:,1)=P(:,:,1);
    %% compute error

    error(1,ncount+1)=sum(sum((A2-A).^2));
    error(2,ncount+1)=sum(sum((B2-B).^2));
    error(3,ncount+1)=sum(sum((C2-C).^2));
    error(4,ncount+1)=sum(sum((D2-D).^2));
    error(5,ncount+1)=sum(sum((R2-R).^2));
    error(6,ncount+1)=sum(sum((Q2-Q).^2));


end




