%% Data-driven discovery of linear dynamical systems in the presence of process and measurement noise
% Example 3: glassfurnace
clear;
clc;
close all;
addpath (genpath('tools')) 
% load dataset
load("data_real_glassfurnace.mat");
total_length = size(glassfurnace, 1);
split_point = floor(2 * total_length/3);  
% dataset and test dataset
U_train = glassfurnace{1:split_point, 2:4}';
Y_train = glassfurnace{1:split_point, 5:7}' + 10;  
U_test = glassfurnace{(split_point+1):total_length, 2:4}';
Y_test = glassfurnace{(split_point+1):total_length, 5:7}' + 10;     
% Initial state
xi = zeros(3, 1); 
rr = 0.0001;  
n = 3; mm = 3; p = 3; Iter_Max = 2000;
T_train = size(Y_train, 2);
T_test = size(Y_test, 2);
%% N4SID 
Ts = 1;
data = iddata(Y_train', U_train', Ts);
n4sid_sys = n4sid(data, n);
% mean relative error
[X_n4sid_sys, Y_n4sid_sys] = state_space_init_predict(n4sid_sys.A, n4sid_sys.B, n4sid_sys.C, n4sid_sys.D, U_test, Y_test, T_test);
norm_relative_errors_n4sid = calculate_relative_errors(Y_test, Y_n4sid_sys);
average_norm_relative_error_n4sid = mean(norm_relative_errors_n4sid);
%% PEM 
data = iddata(Y_train', U_train', 1);
A_in = eye(3); B_in = eye(3); C_in = eye(3); D_in = eye(3); K_in = eye(3); x0 = [0,0,0]';
sys_in = idss(A_in, B_in, C_in, D_in, K_in, x0);
pem_sys = pem(data, sys_in);
%mean relative error
[X_pem, Y_pem] = state_space_init_predict(pem_sys.A, pem_sys.B, pem_sys.C, pem_sys.D, U_test, Y_test, T_test);
norm_relative_errors_pem = calculate_relative_errors(Y_test, Y_pem);
average_norm_relative_error_pem = mean(norm_relative_errors_pem);
%% Our Method 
[A_our, B_our, C_our, D_our, R_our, Q_our, GaA_our, GaB_our, GaC_our, GaD_our, mu_our, error_our] = Our_Method(Y_train, U_train, n, mm, p, T_train, Iter_Max, xi, rr);
% mean relative error
[X_our, Y_our] = state_space_init_predict(A_our, B_our, C_our, D_our, U_test, Y_test, T_test);
norm_relative_errors_our = calculate_relative_errors(Y_test, Y_our);
average_norm_relative_error_our = mean(norm_relative_errors_our);

%% MLE 
[A_mle, B_mle, C_mle, D_mle, R_mle, Q_mle, GaA_mle, GaB_mle, GaC_mle, GaD_mle, mu_mle, error_mle] = MLE(Y_train, U_train, n, mm, p, T_train, Iter_Max, xi, rr);
% mean relative error
[X_mle, Y_mle] = state_space_init_predict(A_mle, B_mle, C_mle, D_mle, U_test, Y_test, T_test);
norm_relative_errors_mle = calculate_relative_errors(Y_test, Y_mle);
average_norm_relative_error_mle = mean(norm_relative_errors_mle);
%% Display results
disp('Average Norm Relative Error (Our Method): ' + string(average_norm_relative_error_our));
disp('Average Norm Relative Error (MLE): ' + string(average_norm_relative_error_mle));
disp('Average Norm Relative Error (N4SID): ' + string(average_norm_relative_error_n4sid));
disp('Average Norm Relative Error (PEM): ' + string(average_norm_relative_error_pem));


