function [X_predict, Y_predict] = state_space_init_predict(A, B, C, D, U, Y, T)
    % init X_predict and  Y_predict
    X_predict = zeros(size(A, 1), T);
    Y_predict = zeros(size(C, 1), T);
    % Calculate the initial state using the first observation
    X_predict(:,1) =  C \ (Y(:,1) - D * U(:,1)) ;
    Y_predict(:,1) = C * X_predict(:,1) + D * U(:,1);
    for i = 2:T
        X_predict(:,i) = A * X_predict(:,i-1) + B * U(:,i);
        Y_predict(:,i) = C * X_predict(:,i) + D * U(:,i);
    end
    Y_predict(:,1) =Y(:,1);
end