#!/bin/bash
## example script to launch on zhores; change time/partition/gpus/cpus/email/conda&script locations
## You can launch it with `sbatch launch.sh` after this

#SBATCH --job-name=imagenet_drop_005             # Job name
#SBATCH --partition=gpu                      # Queue name
##SBATCH --partition=cpu                      # Queue name
#SBATCH --mail-type=END,FAIL                 # Mail events (NONE, BEGIN, END, FAIL, ALL)
#SBATCH --mail-user=k.fedyanin@skoltech.ru   # Where to send mail
#SBATCH --nodes=1                            # Run all processes on a single node
#SBATCH --ntasks=2                           # Run two task
#SBATCH --cpus-per-task=8                    # Number of CPU cores per task
#SBATCH --mem=80000                           # Job memory request in Megabytes
#SBATCH --gpus=1
#SBATCH --time=20:00:00                      # Time limit hrs:min:sec or dd-hrs:min:sec
#SBATCH --output=/gpfs/gpfs0/k.fedyanin/parallel_log_%j


#MODULE LOAD PART
#module load python/anaconda3

#COMMAND PART
pwd; hostname; date
echo "ImageNet 0.005"

bash
source activate /trinity/home/k.fedyanin/.conda/uncertainty
#cd /trinity/home/k.fedyanin/apps/face_uncertainty/imagenet
# python train.py /gpfs/gpfs0/datasets/ImageNet/ILSVRC2012/ --arch resnet50 -j 7 -b 128 --world-size=1 --print-freq=100
cd /trinity/home/k.fedyanin/apps/face_uncertainty
#python imagenet/imagenet_embeddings.py --arch='spectral' -c='imagenet/model_best_spectral.pth.tar' -b=64
python imagenet_dropout.py --repeats=100 --dropout-rate=0.005 --batch-size=200


date
