from .cutout import CutOut
from .cutdiff import CutDiff
from .cutpaste import CutPaste
from .rotate import Rotate


def process_tuple(args: float or list):
    if isinstance(args, float):
        return args, args
    elif len(args) == 1:
        return args[0], args[0]
    elif len(args) == 2:
        return tuple(args)
    elif len(args) > 2:
        raise ValueError()


def to_aug_function(name, **kwargs):
    if name == 'cutout':
        return CutOut(
            scale=kwargs['scale'],
            ratio=kwargs['ratio'],
        )
    elif name == 'cutpaste':
        return CutPaste(
            scale=kwargs['scale'],
            ratio=kwargs['ratio'],
        )
    elif name == 'cutdiff':
        return CutDiff(
            scale=kwargs['scale'],
            ratio=kwargs['ratio'],
            angle=kwargs['angle'],
        )
    elif name == 'rotate':
        return Rotate(
            angle=kwargs['angle'],
        )
    else:
        raise ValueError(name)
