import argparse
import json
import os

import pandas as pd

ROOT = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


def get_object_types(dataset):
    path = f'{ROOT}/data/{dataset}.tsv'
    df = pd.read_csv(path, sep='\t', header=None, dtype=str)
    return df.iloc[:, 0].unique().tolist()


def get_anomaly_types(dataset, obj_type):
    path = f'{ROOT}/data/{dataset}.tsv'
    df = pd.read_csv(path, sep='\t', header=None, dtype=str)
    return df[df.iloc[:, 0] == obj_type].iloc[:, 1].tolist()


def set_environment(seed=None, num_threads=16):
    import numpy as np
    import torch

    torch.set_num_threads(num_threads)
    if seed is not None:
        np.random.seed(seed)
        torch.manual_seed(seed)
        if torch.cuda.is_available():
            torch.cuda.manual_seed(seed)


def str2bool(v):
    if isinstance(v, bool):
        return v
    if v.lower() in ('yes', 'true', 't', 'y', '1'):
        return True
    elif v.lower() in ('no', 'false', 'f', 'n', '0'):
        return False
    else:
        raise argparse.ArgumentTypeError('Boolean value expected.')


def save_json(out, path):
    with open(path, 'w') as f:
        json.dump(out, f, indent=4, sort_keys=True)

