import os
import importlib


CRITERION_REGISTRY = {}


def register_criterion(criterion_name: str):
    
    def register_criterion_cls(cls):
        if criterion_name in CRITERION_REGISTRY:
            raise ValueError(f"Cannot register duplicate {criterion_name} criterion.")

        CRITERION_REGISTRY[criterion_name] = cls
        return cls
    
    return register_criterion_cls


def get_criterion_list():
    return CRITERION_REGISTRY.keys()


def build_criterion(name: str):
    return CRITERION_REGISTRY[name]()


def import_criterions(criterion_dir: str):

    for file in os.listdir(criterion_dir):
        path = os.path.join(criterion_dir, file)

        if (
            not file.startswith("_")
            and not file.startswith(".")
            and file.endswith(".py")
        ):
            criterion_name = file[:file.find(".py")]
            importlib.import_module("CoLM.criterion." + criterion_name)


import_criterions(os.path.dirname(__file__))