from transformers import HfArgumentParser
from CoLM.configs import PreprocessArg, TrainArg
from CoLM.criterion import get_criterion_list

def parse_training_args() -> TrainArg:
    """Create arguments for training."""
    parser = HfArgumentParser([TrainArg])
    parser._option_string_actions['--criterion'].choices = get_criterion_list()
    args, _ = parser.parse_known_args()
    return args


def parse_preprocess_args() -> PreprocessArg:
    """Create arguments for preprocessing."""
    parser = HfArgumentParser([PreprocessArg])
    args, _ = parser.parse_known_args()

    preprocess_args, = parser.parse_dict(vars(args))
    return preprocess_args
