import sys
import logging

from CoLM import Trainer

from CoLM.models import build_model_and_tokenizer
from CoLM.option import parse_training_args

logging.basicConfig(
    level=logging.INFO, 
    format="%(asctime)s | %(levelname)s | %(name)s | %(message)s",
    datefmt="%Y-%m-%d %H:%M:%S",
    stream=sys.stdout,
)
logger = logging.getLogger("Training")


def main():
    args = parse_training_args()
    model, tokenizer = build_model_and_tokenizer(args)
    
    trainer = Trainer(
        args=args,
        model=model,
        tokenizer=tokenizer,
    )

    logger.info(args)
    logger.info("Start Training")
    trainer.train()
    logger.info("Done")


if __name__ == '__main__':
    main()