import json, os
from tqdm import trange
import argparse

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Evaluate benchmark')
    parser.add_argument('--root_path', type=str, default='', help='root path')
    parser.add_argument('--start_index', type = int, default = 0)
    parser.add_argument('--end_index', type = int, default = 100)
    
    args = parser.parse_args()
    root_path = args.root_path
    
    avg_acc = 0
    avg_bias = 0
    avg_score = 0
    num = 0
    
    best_eval_results = []
    dic = {}
    for i in trange(args.start_index, args.end_index):
        temp_path = os.path.join(root_path, f'{i}')
        if not os.path.exists(temp_path):
            break
        temp_list = os.listdir(temp_path)
        max_acc = -1
        best_dict = None
        for file in temp_list:
            if file.endswith('.json') and 'metadata' not in file:
                with open(os.path.join(temp_path, file), 'r') as f:
                    data = json.load(f)
                    acc = data['all_acc']
                    if acc > max_acc:
                        max_acc = acc
                        best_dict = data
            elif 'metadata' in file:
                with open(os.path.join(temp_path, file), 'r') as f:
                    data = json.load(f)
                    prompt = data['prompt']
        if best_dict is None:
            raise ValueError('No json file found')
        best_eval_results.append(best_dict)
        dic[f'{temp_path}/gen.png'] = {
            'prompt' : prompt,
            'acc' : best_dict['all_acc'],
            'bias' : best_dict['all_bias'],
            'score' : 0.5 * (best_dict['all_acc'] + 1 / (best_dict['all_bias'] + 1)),
        }
        avg_acc += best_dict['all_acc']
        avg_bias += best_dict['all_bias']
        avg_score += 0.5 * (best_dict['all_acc'] + 1 / (best_dict['all_bias'] + 1))
        num += 1
    
    avg_acc /= num
    avg_bias /= num
    avg_score /= num
    dic['avg_acc'] = avg_acc
    dic['avg_bias'] = avg_bias
    dic['avg_score'] = avg_score
    dic['num'] = num
            
    with open(os.path.join(root_path, f'm3t2ibench_score.json'), 'w') as f:
        json.dump(dic, f, indent = 4)
    root_path = os.path.join(root_path, f'multi_evaluation/')
    os.makedirs(root_path, exist_ok = True)
    with open(os.path.join(root_path, f'best_eval_results.json'), 'w') as f:
        json.dump(best_eval_results, f, indent = 4)
    
    
