ReadMe for the supplementary material of the paper:

Template based Graph Neural Network with Optimal Transport Distances.

The zip file contains:

1) the file supplementary.pdf which provides complements to the main paper namely:

    - The proof for our lemma 1
    - Details on the experiments on the synthetic datasets 4-CYCLES and SKIP-CIRCLES (visualizations, settings)
    - Additional experiments where the number of templates for SKIP-CIRCLES is lower than the number of classes
    - Details on the settings for the benchmark of setting 3.2
    - Additional visualizations for the section 3.3 (on our embeddings and on our learned templates)
    - Benchmark of the sensitivity to the number of GIN layers for the model GIN on the dataset PTC.


2) The code to reproduce our experiments:

Any method can either be run on cpu or gpu. See the commented run files for further details to reproduce our experiments. 

We join to our code a copy of our conda environment

    environment.yml

where no prefix has been set for anonymization so you might have to set your own prefix to download this environment.

For our method TFGW:

    - TFGW_raw.py : contains models to learn our TFGW layer without GNN pre-processing the features:

        - The class FGWmachine uses the FGW distance where alpha can take values in (0,1) and if alpha = -1, will learn this parameter
        - The class GWmachine uses the GW distance i.e force alpha=1. With this method it is possible to either learn the templates or letting them fixed
        - run_synthetic_datasets.py : to reproduce our experiments on the synthetic datasets which use the method GWmachine in its both configuration (TFGW-fix / TFGW - with alpha fixed to 1). See subsection 3.1.
        - run_TFGW_raw.py : to reproduce our experiments on the real datasets reported in the section 3.3 (Table 4) when no GNN is considered (L=0).

    - TFGW_GIN.py : contains the full TFGW model with GNN pre-processing.

        - run_TFGW_GIN.py : to reproduce our experiments on the real datasets using TFGW_GIN, reported in the section 3 (Table 2 and 4).

For the benchmarked methods: all files are provided with the method in its dedicated subrepository and the run files to reproduce the experiments of the benchmark reported in Table 2. Our implementations are similar than the ones given by the authors in the github quoted in respective run files, up to few modifications to do the CV validation proposed in section 3.2.

    - OT-GNN : subrepository OT_GNN/ , with run file run_OT_GNN.py
    - WEGL : subrepository WEGL/ with run file WEGL/WEGL.py
    - PATCHYSAN: subrepository PATCHYSAN/ with run file PATCHYSAN/PATCHYSAN.py
    - GIN: subrepository GIN/GIN.py with run file run_GIN.py
    - DropGIN: subrepository GIN/GIN.py with run file run_DropGIN.py
    - DIFFPOOL: subrepository diffpool/ with run file train_diffpool.py
    - FGW Kernels: subrepository Kernels/ with run file run_FGWkernels.py
    - (W)WL Kernels: subrepository Kernels/ with run file run_WWLkernels.py



        