# AMemGym (Assistant Memory Gym)

### environment setup

`uv sync`

### data preparation

All data files are placed in the `data` folder.

### example assistant configurations

Example configurations for different assistants can be found in the `configs` folder.

### evaluation for random baseline

```bash
python evaluate_random.py --data_file "data_file_path" --output_file "output_file_path"
```

### evaluate upperbound

```bash
python evaluate_utilization.py --data_file "data_file_path" --output_dir "output_dir_path" --url "openai_api_url" --api_key "openai_api_key"
```

### evaluate overall performance

```bash
python evaluate_overall.py --env_data "data_file_path" --env_config "env_config_path" --output_dir "output_dir_path" --url "openai_api_url" --api_key "openai_api_key" --agent_config "assistant_config_path"
```

### evaluate diagnostic performance

```bash
python diagnose.py --env_data "data_file_path" --env_config "env_config_path" --output_dir "output_dir_path" --url "openai_api_url" --api_key "openai_api_key" --agent_config "assistant_config_path"
```

### visualize results

```bash
python plot_metrics.py --config_path "figure_config_path" --data_path "data_path" --output_path "output_path"
```
