import torch
import numpy as np
import pandas as pd
from transformers import AutoTokenizer, AutoModel
import os
import random
from rebuttal_model import GDMask



def eigen(X):
    gram_matrix = X @ X.T
    eigenvalues = torch.linalg.eigvalsh(gram_matrix)
    min_eigenvalue = torch.min(eigenvalues)
    return min_eigenvalue

def assumption_1():
    min_eigenvalue_in_all = 999999
    for i in range(8):
        file_name = f"C4/14/sentence_{i}_embedding.npy" 
        with open(file_name, 'rb') as f:
            embedding = np.load(f)
            embedding = torch.tensor(embedding, dtype=torch.float32)
            embedding = embedding.squeeze(0)
            min_eigenvalue = eigen(embedding)
            min_eigenvalue_in_all = min(min_eigenvalue_in_all, min_eigenvalue)
    return min_eigenvalue_in_all


def assumption_2():
    llama_model = AutoModel.from_pretrained("llama3.2")
    ground_truth_model = GDMask(llama_model.config)
    ground_truth_model.q_proj.weight.data = llama_model.layers[0].self_attn.q_proj.weight.clone()
    ground_truth_model.k_proj.weight.data = llama_model.layers[0].self_attn.k_proj.weight.clone()
    min_activation = 999999
    for i in range(8):
        file_name = f"C4/-1/sentence_{i}_embedding.npy" 
        with open(file_name, 'rb') as f:
            embedding = np.load(f)
            embedding = torch.tensor(embedding, dtype=torch.float32)
            _, f_m = ground_truth_model(embedding)
            min_activation = min(min_activation, torch.min(f_m))
    return min_activation
            
    