import os
import csv
import shutil

image_path = "../De-stereotype/dataset_diy/data/"


def image_category(image_path):
    count = 1
    files_nums = 1
    image_path_list = os.listdir(image_path)
    image_path_list.sort(key=lambda fn: os.path.getmtime(image_path + "/" + fn))
    for image in image_path_list:
        files_path = os.path.join(image_path, str(files_nums).zfill(4))
        if not os.path.exists(files_path):
            os.makedirs(files_path)
        if count % 10 == 0:
            files_nums += 1
        # remove the image to files_path
        shutil.move(os.path.join(image_path, image), files_path)
        print("move {} to {}".format(image, files_path))
        count += 1


def file_rename(image_path):
    start = 3
    for files in os.listdir(image_path):
        files_path = os.path.join(image_path, files)
        for image in os.listdir(files_path):
            image_path = os.path.join(files_path, image)
            new_name = os.path.join(files_path, str(start).zfill(4))
            os.rename(image_path, new_name)
            print("rename {} to {}".format(image_path, new_name))
            start += 1


# file_rename(image_path)
image_category(image_path)