# Contributing to the AIF360 R package

This guide is divided into three main parts:

1. Filing a bug report or feature request in an issue.
2. Suggesting a change via a pull request.
3. New features or enhancements to AIF360 functionality.

If you're not familiar with git or GitHub, please start by reading <http://r-pkgs.had.co.nz/git.html>

Please note that the AIF360 R package is released with a [Contributor Code of Conduct](CODEOFCONDUCT.md). By contributing to this project,
you agree to abide by its terms.

## Issues

If you find a bug, please search GitHub under [Issues](https://github.com/Trusted-AI/AIF360/issues) to ensure the bug was not already reported.
If you’re unable to find an open issue addressing the problem, [open a new one](https://github.com/Trusted-AI/AIF360/issues/new). Please include a title and clear description, as much relevant information as possible (such as required packages, data, etc.), and a code sample to replicate the issue.

## Pull requests

To contribute a change to the AIF360 R package, you follow these steps:

* Create a branch in git and make your changes.
* Push branch to GitHub and open a new pull request (PR).
* Ensure the PR description clearly describes the problem and solution. Include the relevant issue number if applicable.

## New Features

The AIF360 R package is part of [AI Fairness 360](https://github.com/Trusted-AI/AIF360), developed with extensibility in mind. If you wish to suggest new metrics, explainers, algorithms or datasets. Please get in touch on [Slack]( https://aif360.slack.com) (invitation [here](https://aif360.slack.com/join/shared_invite/zt-5hfvuafo-X0~g6tgJQ~7tIAT~S294TQ))!

