# import
from transformers import AutoProcessor, AutoModel
from PIL import Image
import torch
import glob
import csv
from tqdm import tqdm
import os
# load model
device = "cuda"
processor_name_or_path = "laion/CLIP-ViT-H-14-laion2B-s32B-b79K"
model_pretrained_name_or_path = "yuvalkirstain/PickScore_v1"

processor = AutoProcessor.from_pretrained(processor_name_or_path)
model = AutoModel.from_pretrained(model_pretrained_name_or_path).eval().to(device)

def calc_probs(prompt, images):
    
    # preprocess
    image_inputs = processor(
        images=images,
        padding=True,
        truncation=True,
        max_length=77,
        return_tensors="pt",
    ).to(device)
    
    text_inputs = processor(
        text=prompt,
        padding=True,
        truncation=True,
        max_length=77,
        return_tensors="pt",
    ).to(device)


    with torch.no_grad():
        # embed

        image_embs = model.get_image_features(**image_inputs)
        image_embs = image_embs / torch.norm(image_embs, dim=-1, keepdim=True)
    
        text_embs = model.get_text_features(**text_inputs)
        text_embs = text_embs / torch.norm(text_embs, dim=-1, keepdim=True)
    
        # score
        scores = model.logit_scale.exp() * (text_embs @ image_embs.T)[0]
        
        # get probabilities if you have multiple images to choose from
        # probs = torch.softmax(scores, dim=-1)
    
    return scores.cpu().numpy()
dir = "./results_images/results"
path_names = os.listdir(dir)
for path_name in path_names:
    struct_dict = {}
    save_txt = f"./results/pickscore_{path_name}.txt"
    save_csv = f"./results/pickscore_{path_name}.csv"

    results_images = glob.glob(f"{dir}/{path_name}/results/*")
    scores = 0.0
    list_dict = []
    for image_path in tqdm(results_images):
        pil_images = Image.open(image_path)
        struct_image_name = image_path.split('/')[-1].split("_s_")[0].replace("c_","").split("_")[-1]
        prompt = f"a photo of {struct_image_name}"
        print(prompt)
        score = calc_probs(prompt, pil_images)

        scores += score[0]
        print(score[0])
        data_dict = {}
        data_dict["image_path"] = image_path
        data_dict["pickscore"] = score[0]
        list_dict.append(data_dict)
    avg_score = scores / len(results_images)
    print(f"{avg_score=}")

    with open(save_txt,'w') as f:
        f.write(f"{avg_score=}\n")
    with open(save_csv, mode='w', newline='') as file:
        writer = csv.DictWriter(file, fieldnames=list_dict[0].keys())
        writer.writeheader()
        for row in list_dict:
            writer.writerow(row)
        