# from models.pipeline_stable_video_diffusion import StableVideoDiffusionPipeline
from diffusers import DDIMScheduler, KDPM2DiscreteScheduler, StableVideoDiffusionPipeline, EulerAncestralDiscreteScheduler
from diffusers.utils import load_image, export_to_video
from utils.image_utils import load_size
import torch
from typing import Union, List
from PIL import Image
pipe = StableVideoDiffusionPipeline.from_pretrained(
    "stabilityai/stable-video-diffusion-img2vid", torch_dtype=torch.float16, variant="fp16"
    )

pipe.to("cuda")

image = load_image(
    "./dataset/image1.png"
    )
image = image.resize((512, 512))

frames = pipe(image, num_frames=25, decode_chunk_size=8, height=512, width=512).frames[0]

export_to_video(frames, "./videos/watermelon.mp4", fps=7)
