import json
import random
random.seed(0)
from pathlib import Path
from tqdm import tqdm
from Scorer import available_scores, Scorer
import glob
from tqdm import tqdm
import csv
import os
cache_dir = "./ckpt/metrics_ckpts"

if __name__ == '__main__':

    score_names = ["HPS"]
    scorer = Scorer(score_names, download_root=cache_dir)
    dir = "results_images/results"
    path_names = os.listdir(dir)
    for path_name in path_names:
        struct_dict = {}
        save_txt = f"./results/hps_{path_name}.txt"
        save_csv = f"./results/hps_{path_name}.csv"

        results_images = glob.glob(f"{dir}/{path_name}/results/*")
        scores = 0.0
        list_dict = []
        for image_path in tqdm(results_images):
            struct_image_name = image_path.split('/')[-1].split("_s_")[0].replace("c_","").replace("_"," ")
            prompts = f"a photo of a {struct_image_name}"
            metrics = scorer(prompts, image_path, batch_size=20)
            print(metrics)
            scores += metrics["Human Preference Score"][0]
            data_dict = {}
            data_dict["image_path"] = image_path
            data_dict["HPS"] = metrics["Human Preference Score"][0]
            list_dict.append(data_dict)
            
        avg_score = scores / len(results_images)
        print(avg_score)

        with open(save_txt,'w') as f:
            f.write(f"{avg_score=}\n")
        with open(save_csv, mode='w', newline='') as file:
            writer = csv.DictWriter(file, fieldnames=list_dict[0].keys())
            writer.writeheader()
            for row in list_dict:
                writer.writerow(row)
