import cv2
import numpy as np
import PIL
from PIL import Image
from typing import Union, List

def read_from_video(video_path: str, as_pil: bool = False) -> List[Union[np.ndarray, PIL.Image.Image]]:
    """
    Reads an MP4 video from the specified path and returns the frames as a list of NumPy arrays or PIL Image objects.

    Args:
    video_path (str): The path to the input video file.
    as_pil (bool): If True, returns frames as PIL.Image.Image objects; otherwise, returns as numpy arrays.

    Returns:
    List[Union[np.ndarray, PIL.Image.Image]]: A list of video frames in the requested format.
    """


    cap = cv2.VideoCapture(video_path)
    if not cap.isOpened():
        raise IOError(f"Cannot open video file {video_path}")

    frames = []
    while True:
        ret, frame = cap.read()
        if not ret:
            break
        if as_pil:
            # Convert frame from BGR to RGB color space before converting to PIL Image
            frame = cv2.cvtColor(frame, cv2.COLOR_BGR2RGB)
            Image.fromarray(frame).save("./temp.png")
            frames.append(Image.fromarray(frame))
        else:
            # Convert frame from BGR to RGB to maintain consistency with typical image data
            frame = cv2.cvtColor(frame, cv2.COLOR_BGR2RGB)
            frames.append(frame)

    cap.release()
    return frames