import json
import random
import numpy as np

datas = "sqa"
mmmu_total = ['Accounting', 'Agriculture', 'Architecture_and_Engineering', 'Art', 'Art_Theory', 'Basic_Medical_Science', 'Biology', 'Chemistry', 'Clinical_Medicine', 'Computer_Science', 'Design', 'Diagnostics_and_Laboratory_Medicine', 'Economics', 'Electronics', 'Energy_and_Power', 'Finance', 'Geography', 'History', 'Literature', 'Manage', 'Marketing', 'Materials', 'Math', 'Mechanical_Engineering', 'Music', 'Pharmacy', 'Physics', 'Psychology', 'Public_Health', 'Sociology']
mmmu_except = ['Architecture_and_Engineering', 'Electronics', 'Energy_and_Power', 'Materials', 'Music', 'Mechanical_Engineering']

data = json.load(open(f'/data/{datas}/test.json', 'r'))
result = []
for _ in range(1000):
    total = 0
    count = 0
    for each in data:
        if each.get('type') is None or each['type'] not in mmmu_except:
            total += 1
            options = each["vqa_question"].split('\nOptions:\n')[-1].split('\nAnswer:')[0]
            options = len(options.split('\n ('))
            random_guess = random.randint(0, options - 1)
            if chr(random_guess + ord('A')) == each['candidate'][0]:
                count += 1
    result.append(count/total)
print(np.mean(result))