import json
import pandas as pd

model_list = [
    'microsoft/Phi-3.5-vision-instruct',
    'openbmb/MiniCPM-V-2_6',
    'Qwen/Qwen2-VL-7B-Instruct',
    'llava-hf/llama3-llava-next-8b-hf',
    'HuggingFaceM4/idefics2-8b',
    'THUDM/glm-4v-9b',
    'llava-hf/llava-v1.6-34b-hf',
    'OpenGVLab/InternVL2-Llama3-76B'
]


def find_all_numbers(input_string):
    import re
    numbers = re.findall(r'\d+', input_string)
    return numbers


def judge(datasets, data):
    count = 0
    for each in data:
        if datasets == 'infoseek' and isinstance(each['candidate'][0], dict):
            ranges = each['candidate'][0]["range"]
            pre_nums = find_all_numbers(each['pred'])
            for nums in pre_nums:
                if float(nums) >= ranges[0] and float(nums) <= ranges[1]:
                    count += 1
                    break
        else:
            fp = each['pred'].lower().replace('"', '').replace("'", "").replace('the ', '').replace('-', ' ')
            for c in each['candidate']:
                fc = c.lower().replace('"', '').replace("'", "").replace('the ', '').replace('-', ' ')
                if fp.count(fc) > 0:
                    count += 1
                    break
    return count
        


dataset = 'infoseek'
result = []
for model in model_list:
    name = model.split('/')[-1]
    temp = {"model": name}
    for mode in ['q', 'qr1', 'qr3', 'qr5', 'qrx'][:4]:
        try:
            if mode == 'q':
                try: data = json.load(open(f'/result/{dataset}/vllm/{mode}_{name}_result.json'))
                except: data = json.load(open(f'/result/{dataset}/vllm/{name}_result.json', 'r'))
            else:
                data = json.load(open(f'/result/{dataset}/vllm/{mode}_{name}_result.json'))
        except:
            print(mode)
            raise
        correct = judge(dataset, data)
        temp[mode] = round(correct / len(data) * 100, 1)
    result.append(temp)

result = pd.DataFrame(result)
print(result)