import json

infoseek = json.load(open('/data/viquae/test.json', 'r'))
infoseek_ext = json.load(open('/embedding/knowledge/viquae.json', 'r'))

infoseek = {each['id']: each['entity'] for each in infoseek}
infoseek_ext = {each['id']: each['advices'] for each in infoseek_ext}

count_1, count_3, count_5, count_10, count_50, count_100 = 0, 0, 0, 0, 0, 0
for k, v in infoseek.items():
    advice = infoseek_ext[k]
    sort_advice = sorted(advice, key=lambda x: x[0], reverse=True)
    recall_1 = [each[1] for each in sort_advice[:1]]
    recall_3 = [each[1] for each in sort_advice[:3]]
    recall_5 = [each[1] for each in sort_advice[:5]]
    recall_10 = [each[1] for each in sort_advice[:10]]
    recall_50 = [each[1] for each in sort_advice[:50]]
    recall_100 = [each[1] for each in sort_advice[:100]]
    for each in recall_1:
        if v in each:
            count_1 += 1
            break
    for each in recall_3:
        if v in each:
            count_3 += 1
            break
    for each in recall_5:
        if v in each:
            count_5 += 1
            break
    for each in recall_10:
        if v in each:
            count_10 += 1
            break
    for each in recall_50:
        if v in each:
            count_50 += 1
            break
    for each in recall_100:
        if v in each:
            count_100 += 1
            break

print(f"{round(count_1 * 100 / len(infoseek), 2)}%")
print(f"{round(count_3 * 100 / len(infoseek), 2)}%")
print(f"{round(count_5 * 100 / len(infoseek), 2)}%")
print(f"{round(count_10 * 100 / len(infoseek), 2)}%")
print(f"{round(count_50 * 100 / len(infoseek), 2)}%")
print(f"{round(count_100 * 100 / len(infoseek), 2)}%")