import json
import copy

infoseek = json.load(open('/data/infoseek/testkn.json', 'r'))
infoseek_ext = json.load(open('/embedding/knowledge/infoseek.json', 'r'))

infoseek = {each['id']: each for each in infoseek}
infoseek_ext = {each['id']: each['advices'] for each in infoseek_ext}

result = []
for k, v in infoseek.items():
    advice = infoseek_ext[k]
    sort_advice = sorted(advice, key=lambda x: x[0], reverse=True)
    temp = copy.deepcopy(v)
    temp['advice'] = [each[-1] for each in sort_advice[:10]]
    result.append(temp)

json.dump(result, open('/data/infoseek/test.json', 'w'), indent=4, ensure_ascii=False)
    