import gurobi as gp

# Create a new model
model = gp.Model("Rings_and_Necklaces")

# Define variables
R = model.addVar(name="Rings", lb=0, vtype=gp.GRB.CONTINUOUS)
N = model.addVar(name="Necklaces", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective: Maximize profit
model.setObjective(50*R + 75*N, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(R + 3*N <= 15, name="Heating_Machine_Constraint")
model.addConstr(2*R + 4*N <= 12, name="Polishing_Machine_Constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"Rings to produce: {R.varValue:.2f}")
    print(f"Necklaces to produce: {N.varValue:.2f}")
else:
    print("The problem is infeasible.")
