
from gurobipy import Model, GRB

# Create a new model
model = Model("Work_Optimization")

# Create variables
dale_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Dale_Hours")
paul_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="Paul_Hours")
laura_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Laura_Hours")
jean_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Jean_Hours")

# Set objective function
model.setObjective(5 * dale_hours + 2 * paul_hours + 5 * laura_hours + 3 * jean_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(11 * dale_hours + 7 * paul_hours + 3 * jean_hours >= 16, "Work_Quality_1")
model.addConstr(1 * paul_hours + 5 * laura_hours + 10 * jean_hours >= 14, "Dollar_Cost_1")
model.addConstr(9 * dale_hours + 7 * jean_hours >= 12, "Productivity_1")
model.addConstr(9 * dale_hours + 10 * paul_hours >= 21, "Productivity_2")
model.addConstr(10 * paul_hours + 1 * laura_hours >= 13, "Productivity_3")
model.addConstr(-7 * laura_hours + 1 * jean_hours >= 0, "Laura_Jean_Hours")
model.addConstr(7 * paul_hours + 3 * jean_hours <= 81, "Work_Quality_2")
model.addConstr(11 * dale_hours + 3 * jean_hours <= 43, "Work_Quality_3")
model.addConstr(7 * paul_hours + 7 * laura_hours <= 31, "Work_Quality_4")
model.addConstr(7 * paul_hours + 7 * laura_hours + 3 * jean_hours <= 90, "Work_Quality_5")
model.addConstr(11 * dale_hours + 7 * paul_hours + 3 * jean_hours <= 23, "Work_Quality_6")
model.addConstr(11 * dale_hours + 7 * paul_hours + 7 * laura_hours + 3 * jean_hours <= 23, "Work_Quality_7")
model.addConstr(1 * paul_hours + 10 * jean_hours <= 38, "Dollar_Cost_2")
model.addConstr(1 * paul_hours + 5 * laura_hours <= 33, "Dollar_Cost_3")
model.addConstr(4 * dale_hours + 10 * jean_hours <= 55, "Dollar_Cost_4")
model.addConstr(4 * dale_hours + 1 * paul_hours + 10 * jean_hours <= 32, "Dollar_Cost_5")
model.addConstr(4 * dale_hours + 1 * paul_hours + 5 * laura_hours + 10 * jean_hours <= 32, "Dollar_Cost_6")
model.addConstr(1 * laura_hours + 7 * jean_hours <= 42, "Productivity_4")
model.addConstr(10 * paul_hours + 1 * laura_hours + 7 * jean_hours <= 49, "Productivity_5")
model.addConstr(9 * dale_hours + 10 * paul_hours + 7 * jean_hours <= 92, "Productivity_6")
model.addConstr(9 * dale_hours + 1 * laura_hours + 7 * jean_hours <= 59, "Productivity_7")
model.addConstr(9 * dale_hours + 10 * paul_hours + 1 * laura_hours <= 50, "Productivity_8")
model.addConstr(9 * dale_hours + 10 * paul_hours + 1 * laura_hours + 7 * jean_hours <= 50, "Productivity_9")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

