
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(lb=0, name="hours_worked_by_Dale", vtype=gp.GRB.CONTINUOUS)
x1 = m.addVar(lb=0, name="hours_worked_by_Paul", vtype=gp.GRB.INTEGER)
x2 = m.addVar(lb=0, name="hours_worked_by_Laura", vtype=gp.GRB.CONTINUOUS)
x3 = m.addVar(lb=0, name="hours_worked_by_Jean", vtype=gp.GRB.CONTINUOUS)

# Define the objective function
m.setObjective(5*x0 + 2*x1 + 5*x2 + 3*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11*x0 + 7*x1 + 3*x3 >= 16)
m.addConstr(x1 + 5*x2 + 10*x3 >= 14)
m.addConstr(9*x0 + 7*x3 >= 12)
m.addConstr(9*x0 + 10*x1 >= 21)
m.addConstr(10*x1 + x2 >= 13)
m.addConstr(-7*x2 + x3 >= 0)
m.addConstr(7*x1 + 3*x3 <= 81)
m.addConstr(11*x0 + 3*x3 <= 43)
m.addConstr(7*x1 + 7*x2 <= 31)
m.addConstr(11*x0 + 7*x1 + 7*x2 + 3*x3 <= 90)
m.addConstr(11*x0 + 7*x1 + 3*x3 <= 23)
m.addConstr(11*x0 + 7*x1 + 7*x2 + 3*x3 <= 23)
m.addConstr(x1 + 10*x3 <= 38)
m.addConstr(x1 + 5*x2 <= 33)
m.addConstr(4*x0 + 10*x3 <= 55)
m.addConstr(4*x0 + x1 + 10*x3 <= 32)
m.addConstr(4*x0 + x1 + 5*x2 + 10*x3 <= 32)
m.addConstr(x2 + 7*x3 <= 42)
m.addConstr(10*x1 + x2 + 7*x3 <= 49)
m.addConstr(9*x0 + 10*x1 + 7*x3 <= 92)
m.addConstr(9*x0 + x2 + 7*x3 <= 59)
m.addConstr(9*x0 + 10*x1 + x2 <= 50)
m.addConstr(9*x0 + 10*x1 + x2 + 7*x3 <= 50)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Dale: ", x0.varValue)
    print("Hours worked by Paul: ", x1.varValue)
    print("Hours worked by Laura: ", x2.varValue)
    print("Hours worked by Jean: ", x3.varValue)
else:
    print("The model is infeasible")
