
import gurobipy as gp

# Create a new model
m = gp.Model("Work_Optimization")

# Create variables
jean_hours = m.addVar(lb=0, name="jean_hours")
bobby_hours = m.addVar(lb=0, name="bobby_hours")
john_hours = m.addVar(lb=0, name="john_hours")

# Set objective function
m.setObjective(6 * jean_hours + 9 * bobby_hours + 1 * john_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11.52 * jean_hours + 4.15 * bobby_hours + 10.69 * john_hours >= 37, "c1")
m.addConstr(0.66 * jean_hours + 12.98 * bobby_hours + 0.6 * john_hours >= 83, "c2")
m.addConstr(3.8 * jean_hours + 2.18 * bobby_hours >= 19, "c3")
m.addConstr(4.15 * bobby_hours + 10.69 * john_hours <= 78, "c4")
m.addConstr(11.52 * jean_hours + 4.15 * bobby_hours <= 134, "c5")
m.addConstr(11.52 * jean_hours + 4.15 * bobby_hours + 10.69 * john_hours <= 134, "c6")
m.addConstr(12.98 * bobby_hours + 0.6 * john_hours <= 239, "c7")
m.addConstr(0.66 * jean_hours + 0.6 * john_hours <= 134, "c8")
m.addConstr(0.66 * jean_hours + 12.98 * bobby_hours + 0.6 * john_hours <= 219, "c9")
m.addConstr(3.8 * jean_hours + 2.18 * bobby_hours <= 61, "c10")
m.addConstr(2.18 * bobby_hours + 4.38 * john_hours <= 90, "c11")
m.addConstr(3.8 * jean_hours + 2.18 * bobby_hours + 4.38 * john_hours <= 89, "c12")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective: %g' % m.objVal)
    print('Jean hours:', jean_hours.x)
    print('Bobby hours:', bobby_hours.x)
    print('John hours:', john_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

