
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(lb=0, name="hours_worked_by_Jean", vtype=gurobi.GRB.CONTINUOUS)
    x1 = model.addVar(lb=0, name="hours_worked_by_Bobby", vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(lb=0, name="hours_worked_by_John", vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(6*x0 + 9*x1 + x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(11.52*x0 + 4.15*x1 + 10.69*x2 >= 37, name="productivity_rating_min")
    model.addConstr(0.66*x0 + 12.98*x1 + 0.6*x2 >= 83, name="dollar_cost_min")
    model.addConstr(3.8*x0 + 2.18*x1 >= 19, name="likelihood_to_quit_min_Jean_Bobby")
    model.addConstr(4.15*x1 + 10.69*x2 <= 78, name="productivity_rating_Bobby_John_max")
    model.addConstr(11.52*x0 + 4.15*x1 <= 134, name="productivity_rating_Jean_Bobby_max")
    model.addConstr(11.52*x0 + 4.15*x1 + 10.69*x2 <= 134, name="productivity_rating_total_max")
    model.addConstr(12.98*x1 + 0.6*x2 <= 239, name="dollar_cost_Bobby_John_max")
    model.addConstr(0.66*x0 + 0.6*x2 <= 134, name="dollar_cost_Jean_John_max")
    model.addConstr(0.66*x0 + 12.98*x1 + 0.6*x2 <= 219, name="dollar_cost_total_max")
    model.addConstr(3.8*x0 + 2.18*x1 <= 61, name="likelihood_to_quit_Jean_Bobby_max")
    model.addConstr(2.18*x1 + 4.38*x2 <= 90, name="likelihood_to_quit_Bobby_John_max")
    model.addConstr(3.8*x0 + 2.18*x1 + 4.38*x2 <= 89, name="likelihood_to_quit_total_max")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Hours worked by Jean: ", x0.x)
        print("Hours worked by Bobby: ", x1.x)
        print("Hours worked by John: ", x2.x)
    else:
        print("The model is infeasible")

optimization_problem()
