
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
iron = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="iron")
protein = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="protein")

# Set objective function
m.setObjective(3 * iron + 2 * protein, GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * iron + 6 * protein >= 14, "muscle_growth_min")
m.addConstr(11 * iron + 7 * protein >= 48, "cognitive_performance_min")
m.addConstr(15 * iron + 15 * protein >= 26, "cardiovascular_support_min")
m.addConstr(2 * iron + 14 * protein >= 22, "kidney_support_min")
m.addConstr(8 * iron + 12 * protein >= 30, "digestive_support_min")
m.addConstr(iron - 5 * protein >= 0, "iron_protein_ratio")

m.addConstr(4 * iron + 6 * protein <= 32, "muscle_growth_max")
m.addConstr(11 * iron + 7 * protein <= 95, "cognitive_performance_max")
m.addConstr(15 * iron + 15 * protein <= 37, "cardiovascular_support_max")
m.addConstr(2 * iron + 14 * protein <= 35, "kidney_support_max")
m.addConstr(8 * iron + 12 * protein <= 67, "digestive_support_max")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Iron: {iron.x}")
    print(f"Protein: {protein.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

