
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="milligrams_of_iron", lb=0)  # lower bound 0, no upper bound
    x1 = model.addVar(name="grams_of_protein", lb=0)  # lower bound 0, no upper bound

    # Define the objective function
    model.setObjective(3 * x0 + 2 * x1, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(4 * x0 + 6 * x1 >= 14, name="muscle_growth_index_min")
    model.addConstr(11 * x0 + 7 * x1 >= 48, name="cognitive_performance_index_min")
    model.addConstr(15 * x0 + 15 * x1 >= 26, name="cardiovascular_support_index_min")
    model.addConstr(2 * x0 + 14 * x1 >= 22, name="kidney_support_index_min")
    model.addConstr(8 * x0 + 12 * x1 >= 30, name="digestive_support_index_min")
    model.addConstr(x0 - 5 * x1 >= 0, name="iron_protein_balance")
    model.addConstr(4 * x0 + 6 * x1 <= 32, name="muscle_growth_index_max")
    model.addConstr(11 * x0 + 7 * x1 <= 95, name="cognitive_performance_index_max")
    model.addConstr(15 * x0 + 15 * x1 <= 37, name="cardiovascular_support_index_max")
    model.addConstr(2 * x0 + 14 * x1 <= 35, name="kidney_support_index_max")
    model.addConstr(8 * x0 + 12 * x1 <= 67, name="digestive_support_index_max")

    # Optimize the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of iron: {x0.varValue}")
        print(f"Grams of protein: {x1.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

solve_optimization_problem()
