
from gurobipy import Model, GRB

# Create a new model
model = Model("Work Optimization")

# Create variables
bobby_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bobby_hours")
dale_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="dale_hours")

# Set objective function
model.setObjective(2.71 * bobby_hours + 4.52 * dale_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(2 * bobby_hours + 6 * dale_hours >= 13, "work_quality_min")
model.addConstr(2 * bobby_hours + 6 * dale_hours <= 25, "work_quality_max")
model.addConstr(7 * bobby_hours + 2 * dale_hours >= 9, "productivity_min")
model.addConstr(7 * bobby_hours + 2 * dale_hours <= 20, "productivity_max")
model.addConstr(-7 * bobby_hours + 5 * dale_hours >= 0, "hours_relationship")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Bobby's hours: {bobby_hours.x}")
    print(f"  Dale's hours: {dale_hours.x}")
    print(f"  Total cost: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

