
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(name='hours_worked_by_Bobby', lb=0)  # Hours worked by Bobby
x1 = m.addVar(name='hours_worked_by_Dale', lb=0)   # Hours worked by Dale

# Set the objective function
m.setObjective(2.71*x0 + 4.52*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x0 + 6*x1 >= 13, name='work_quality_rating_min')
m.addConstr(2*x0 + 6*x1 <= 25, name='work_quality_rating_max')
m.addConstr(7*x0 + 2*x1 >= 9, name='productivity_rating_min')
m.addConstr(7*x0 + 2*x1 <= 20, name='productivity_rating_max')
m.addConstr(-7*x0 + 5*x1 >= 0, name='additional_linear_constraint')

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Hours worked by Bobby: {x0.x}')
    print(f'Hours worked by Dale: {x1.x}')
else:
    print('No optimal solution found')
