
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
hours_worked_by_Bobby = m.addVar(name="hours_worked_by_Bobby", lb=0)  # Assuming hours cannot be negative
hours_worked_by_Dale = m.addVar(name="hours_worked_by_Dale", lb=0)  # Assuming hours cannot be negative

# Objective function
m.setObjective(2.71 * hours_worked_by_Bobby + 4.52 * hours_worked_by_Dale, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(2 * hours_worked_by_Bobby + 6 * hours_worked_by_Dale >= 13, name="work_quality_rating_constraint")
m.addConstr(7 * hours_worked_by_Bobby + 2 * hours_worked_by_Dale >= 9, name="productivity_rating_constraint")
m.addConstr(-7 * hours_worked_by_Bobby + 5 * hours_worked_by_Dale >= 0, name="productivity_work_constraint")
m.addConstr(2 * hours_worked_by_Bobby + 6 * hours_worked_by_Dale <= 25, name="work_quality_upper_bound_constraint")
m.addConstr(7 * hours_worked_by_Bobby + 2 * hours_worked_by_Dale <= 20, name="productivity_upper_bound_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal hours worked by Bobby: {hours_worked_by_Bobby.varValue}")
    print(f"Optimal hours worked by Dale: {hours_worked_by_Dale.varValue}")
    print(f"Objective value: {m.objVal}")
else:
    print("The model is infeasible.")
