
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_e = m.addVar(vtype=GRB.INTEGER, name="vitamin_e")  # Integer
    vitamin_b9 = m.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b9") # Continuous


    # Set objective function
    m.setObjective(4.45 * vitamin_e + 1.29 * vitamin_b9, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(1 * vitamin_e + 7 * vitamin_b9 >= 21, "c0") # Cognitive performance index minimum
    m.addConstr(2 * vitamin_e + 2 * vitamin_b9 >= 20, "c1") # Muscle growth index minimum
    m.addConstr(-3 * vitamin_e + 6 * vitamin_b9 >= 0, "c2")
    m.addConstr(1 * vitamin_e + 7 * vitamin_b9 <= 47, "c3") # Cognitive performance index maximum
    m.addConstr(2 * vitamin_e + 2 * vitamin_b9 <= 28, "c4") # Muscle growth index maximum


    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print(f"Optimal objective value: {m.objVal}")
        print(f"Milligrams of Vitamin E: {vitamin_e.x}")
        print(f"Milligrams of Vitamin B9: {vitamin_b9.x}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
