
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_E")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B9")

# Set the objective function
m.setObjective(4.45*x0 + 1.29*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(1*x0 + 7*x1 >= 21, name="cognitive_performance_index_lower_bound")
m.addConstr(2*x0 + 2*x1 >= 20, name="muscle_growth_index_lower_bound")
m.addConstr(-3*x0 + 6*x1 >= 0, name="additional_linear_constraint")
m.addConstr(1*x0 + 7*x1 <= 47, name="cognitive_performance_index_upper_bound")
m.addConstr(2*x0 + 2*x1 <= 28, name="muscle_growth_index_upper_bound")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of Vitamin E: {x0.x}")
    print(f"Milligrams of Vitamin B9: {x1.x}")
else:
    print("No optimal solution found. The model is either infeasible or unbounded.")
